@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleAbortMultipartUploadArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property createdBeforeDate Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
 * @property days Specifies the number of days noncurrent object versions transition.
 */
public data class BucketLifecycleRuleAbortMultipartUploadArgs(
    public val createdBeforeDate: Output<String>? = null,
    public val days: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleAbortMultipartUploadArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleAbortMultipartUploadArgs = com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleAbortMultipartUploadArgs.builder()
        .createdBeforeDate(createdBeforeDate?.applyValue({ args0 -> args0 }))
        .days(days?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleRuleAbortMultipartUploadArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleAbortMultipartUploadArgsBuilder internal constructor() {
    private var createdBeforeDate: Output<String>? = null

    private var days: Output<Int>? = null

    /**
     * @param value Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
     */
    @JvmName("yqcusjelgkgbpkmy")
    public suspend fun createdBeforeDate(`value`: Output<String>) {
        this.createdBeforeDate = value
    }

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("qdsvgsrnlmckxkry")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
     */
    @JvmName("vrekntfpbcxcxjee")
    public suspend fun createdBeforeDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdBeforeDate = mapped
    }

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("lviuagnhhdeaynnc")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    internal fun build(): BucketLifecycleRuleAbortMultipartUploadArgs =
        BucketLifecycleRuleAbortMultipartUploadArgs(
            createdBeforeDate = createdBeforeDate,
            days = days,
        )
}
