@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property abortMultipartUploads Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
 * @property enabled Specifies lifecycle rule status.
 * @property expirations Specifies a period in the object's expire. See `expiration` below.
 * @property filter Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.
 * `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
 * @property id Unique identifier for the rule. If omitted, OSS bucket will assign a unique name.
 * @property noncurrentVersionExpirations Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
 * @property noncurrentVersionTransitions Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
 * @property prefix The prefix in the names of the objects to which the lifecycle rule does not apply.
 * @property tags Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
 * @property transitions Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
 */
public data class BucketLifecycleRuleArgs(
    public val abortMultipartUploads: Output<List<BucketLifecycleRuleAbortMultipartUploadArgs>>? =
        null,
    public val enabled: Output<Boolean>,
    public val expirations: Output<List<BucketLifecycleRuleExpirationArgs>>? = null,
    public val filter: Output<BucketLifecycleRuleFilterArgs>? = null,
    public val id: Output<String>? = null,
    public val noncurrentVersionExpirations: Output<List<BucketLifecycleRuleNoncurrentVersionExpirationArgs>>? = null,
    public val noncurrentVersionTransitions: Output<List<BucketLifecycleRuleNoncurrentVersionTransitionArgs>>? = null,
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitions: Output<List<BucketLifecycleRuleTransitionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleArgs =
        com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleArgs.builder()
            .abortMultipartUploads(
                abortMultipartUploads?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .expirations(
                expirations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .noncurrentVersionExpirations(
                noncurrentVersionExpirations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .noncurrentVersionTransitions(
                noncurrentVersionTransitions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitions(
                transitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketLifecycleRuleArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleArgsBuilder internal constructor() {
    private var abortMultipartUploads: Output<List<BucketLifecycleRuleAbortMultipartUploadArgs>>? =
        null

    private var enabled: Output<Boolean>? = null

    private var expirations: Output<List<BucketLifecycleRuleExpirationArgs>>? = null

    private var filter: Output<BucketLifecycleRuleFilterArgs>? = null

    private var id: Output<String>? = null

    private var noncurrentVersionExpirations:
        Output<List<BucketLifecycleRuleNoncurrentVersionExpirationArgs>>? = null

    private var noncurrentVersionTransitions:
        Output<List<BucketLifecycleRuleNoncurrentVersionTransitionArgs>>? = null

    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitions: Output<List<BucketLifecycleRuleTransitionArgs>>? = null

    /**
     * @param value Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
     */
    @JvmName("hwkcmylmrondupne")
    public suspend fun abortMultipartUploads(`value`: Output<List<BucketLifecycleRuleAbortMultipartUploadArgs>>) {
        this.abortMultipartUploads = value
    }

    @JvmName("wtrwocdsdwquxspv")
    public suspend fun abortMultipartUploads(vararg values: Output<BucketLifecycleRuleAbortMultipartUploadArgs>) {
        this.abortMultipartUploads = Output.all(values.asList())
    }

    /**
     * @param values Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
     */
    @JvmName("ywliluovhrykpsqu")
    public suspend fun abortMultipartUploads(values: List<Output<BucketLifecycleRuleAbortMultipartUploadArgs>>) {
        this.abortMultipartUploads = Output.all(values)
    }

    /**
     * @param value Specifies lifecycle rule status.
     */
    @JvmName("kvfovjgxnsueconh")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies a period in the object's expire. See `expiration` below.
     */
    @JvmName("lyqasquymvnuaxhc")
    public suspend fun expirations(`value`: Output<List<BucketLifecycleRuleExpirationArgs>>) {
        this.expirations = value
    }

    @JvmName("duqfbdqntvtbkjvr")
    public suspend fun expirations(vararg values: Output<BucketLifecycleRuleExpirationArgs>) {
        this.expirations = Output.all(values.asList())
    }

    /**
     * @param values Specifies a period in the object's expire. See `expiration` below.
     */
    @JvmName("vrqewhqstkocboxa")
    public suspend fun expirations(values: List<Output<BucketLifecycleRuleExpirationArgs>>) {
        this.expirations = Output.all(values)
    }

    /**
     * @param value Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.
     * `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
     */
    @JvmName("krxcmutxscctjsyu")
    public suspend fun filter(`value`: Output<BucketLifecycleRuleFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Unique identifier for the rule. If omitted, OSS bucket will assign a unique name.
     */
    @JvmName("fyasyvxakejflvpm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
     */
    @JvmName("skabpwmafrbymfti")
    public suspend fun noncurrentVersionExpirations(`value`: Output<List<BucketLifecycleRuleNoncurrentVersionExpirationArgs>>) {
        this.noncurrentVersionExpirations = value
    }

    @JvmName("vuogccawcyaehcwc")
    public suspend fun noncurrentVersionExpirations(vararg values: Output<BucketLifecycleRuleNoncurrentVersionExpirationArgs>) {
        this.noncurrentVersionExpirations = Output.all(values.asList())
    }

    /**
     * @param values Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
     */
    @JvmName("drwtqugojdwifvok")
    public suspend fun noncurrentVersionExpirations(values: List<Output<BucketLifecycleRuleNoncurrentVersionExpirationArgs>>) {
        this.noncurrentVersionExpirations = Output.all(values)
    }

    /**
     * @param value Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
     */
    @JvmName("hoylophbfsdngxyf")
    public suspend fun noncurrentVersionTransitions(`value`: Output<List<BucketLifecycleRuleNoncurrentVersionTransitionArgs>>) {
        this.noncurrentVersionTransitions = value
    }

    @JvmName("ruiussjykwngaojt")
    public suspend fun noncurrentVersionTransitions(vararg values: Output<BucketLifecycleRuleNoncurrentVersionTransitionArgs>) {
        this.noncurrentVersionTransitions = Output.all(values.asList())
    }

    /**
     * @param values Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
     */
    @JvmName("ccnlvmtveythpbxg")
    public suspend fun noncurrentVersionTransitions(values: List<Output<BucketLifecycleRuleNoncurrentVersionTransitionArgs>>) {
        this.noncurrentVersionTransitions = Output.all(values)
    }

    /**
     * @param value The prefix in the names of the objects to which the lifecycle rule does not apply.
     */
    @JvmName("kmyjusjplnancvnq")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
     */
    @JvmName("mjfecjcrijudnvor")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
     */
    @JvmName("skwbduxhegwvlnpm")
    public suspend fun transitions(`value`: Output<List<BucketLifecycleRuleTransitionArgs>>) {
        this.transitions = value
    }

    @JvmName("jortdstwmacenwdb")
    public suspend fun transitions(vararg values: Output<BucketLifecycleRuleTransitionArgs>) {
        this.transitions = Output.all(values.asList())
    }

    /**
     * @param values Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
     */
    @JvmName("sgrxqkgmrstonhiu")
    public suspend fun transitions(values: List<Output<BucketLifecycleRuleTransitionArgs>>) {
        this.transitions = Output.all(values)
    }

    /**
     * @param value Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
     */
    @JvmName("ctgnbvcnikojnmuv")
    public suspend fun abortMultipartUploads(`value`: List<BucketLifecycleRuleAbortMultipartUploadArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.abortMultipartUploads = mapped
    }

    /**
     * @param argument Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
     */
    @JvmName("qtwcmmaexquosrgv")
    public suspend fun abortMultipartUploads(argument: List<suspend BucketLifecycleRuleAbortMultipartUploadArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleAbortMultipartUploadArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.abortMultipartUploads = mapped
    }

    /**
     * @param argument Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
     */
    @JvmName("urlsybpjxofwnvad")
    public suspend fun abortMultipartUploads(vararg argument: suspend BucketLifecycleRuleAbortMultipartUploadArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleAbortMultipartUploadArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.abortMultipartUploads = mapped
    }

    /**
     * @param argument Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
     */
    @JvmName("ywjxivbxpjyjluqa")
    public suspend fun abortMultipartUploads(argument: suspend BucketLifecycleRuleAbortMultipartUploadArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketLifecycleRuleAbortMultipartUploadArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.abortMultipartUploads = mapped
    }

    /**
     * @param values Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
     */
    @JvmName("sigvxqarmjhpgpai")
    public suspend fun abortMultipartUploads(vararg values: BucketLifecycleRuleAbortMultipartUploadArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.abortMultipartUploads = mapped
    }

    /**
     * @param value Specifies lifecycle rule status.
     */
    @JvmName("nyygwyifpehvffrj")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies a period in the object's expire. See `expiration` below.
     */
    @JvmName("egxkykfgmcjfcaku")
    public suspend fun expirations(`value`: List<BucketLifecycleRuleExpirationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirations = mapped
    }

    /**
     * @param argument Specifies a period in the object's expire. See `expiration` below.
     */
    @JvmName("eluhachavnylntuh")
    public suspend fun expirations(argument: List<suspend BucketLifecycleRuleExpirationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleExpirationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expirations = mapped
    }

    /**
     * @param argument Specifies a period in the object's expire. See `expiration` below.
     */
    @JvmName("erjnrpcrvwyepveo")
    public suspend fun expirations(vararg argument: suspend BucketLifecycleRuleExpirationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleExpirationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expirations = mapped
    }

    /**
     * @param argument Specifies a period in the object's expire. See `expiration` below.
     */
    @JvmName("ycjlhvqnfgklbvsu")
    public suspend fun expirations(argument: suspend BucketLifecycleRuleExpirationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketLifecycleRuleExpirationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.expirations = mapped
    }

    /**
     * @param values Specifies a period in the object's expire. See `expiration` below.
     */
    @JvmName("dyonftyeneprunrb")
    public suspend fun expirations(vararg values: BucketLifecycleRuleExpirationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expirations = mapped
    }

    /**
     * @param value Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.
     * `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
     */
    @JvmName("xpxkepgtgsqdsqdy")
    public suspend fun filter(`value`: BucketLifecycleRuleFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.
     * `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
     */
    @JvmName("yyrvktbyjhxedgju")
    public suspend fun filter(argument: suspend BucketLifecycleRuleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleRuleFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Unique identifier for the rule. If omitted, OSS bucket will assign a unique name.
     */
    @JvmName("kqrjsgxifwrsywnv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
     */
    @JvmName("qmmtxyrpsmmcxnnb")
    public suspend fun noncurrentVersionExpirations(`value`: List<BucketLifecycleRuleNoncurrentVersionExpirationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noncurrentVersionExpirations = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
     */
    @JvmName("tcfuxfpfiswautfs")
    public suspend fun noncurrentVersionExpirations(argument: List<suspend BucketLifecycleRuleNoncurrentVersionExpirationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleNoncurrentVersionExpirationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionExpirations = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
     */
    @JvmName("nrbagxldjpurvkks")
    public suspend fun noncurrentVersionExpirations(vararg argument: suspend BucketLifecycleRuleNoncurrentVersionExpirationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleNoncurrentVersionExpirationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionExpirations = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
     */
    @JvmName("tnhvajqpsbemifuh")
    public suspend fun noncurrentVersionExpirations(argument: suspend BucketLifecycleRuleNoncurrentVersionExpirationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketLifecycleRuleNoncurrentVersionExpirationArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.noncurrentVersionExpirations = mapped
    }

    /**
     * @param values Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
     */
    @JvmName("fomgvfjntwsweykg")
    public suspend fun noncurrentVersionExpirations(vararg values: BucketLifecycleRuleNoncurrentVersionExpirationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noncurrentVersionExpirations = mapped
    }

    /**
     * @param value Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
     */
    @JvmName("vqaunvpfjafddyon")
    public suspend fun noncurrentVersionTransitions(`value`: List<BucketLifecycleRuleNoncurrentVersionTransitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
     */
    @JvmName("bosennddldvkyubv")
    public suspend fun noncurrentVersionTransitions(argument: List<suspend BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
     */
    @JvmName("aojgooibqntvlcpp")
    public suspend fun noncurrentVersionTransitions(vararg argument: suspend BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
     */
    @JvmName("qvynprgxonyguccy")
    public suspend fun noncurrentVersionTransitions(argument: suspend BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param values Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
     */
    @JvmName("skahcomxwxxbghsg")
    public suspend fun noncurrentVersionTransitions(vararg values: BucketLifecycleRuleNoncurrentVersionTransitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param value The prefix in the names of the objects to which the lifecycle rule does not apply.
     */
    @JvmName("jygmisjmdlwtkutm")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
     */
    @JvmName("gelqfysbprafspos")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
     */
    @JvmName("xnifgkgmtgoxmchn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
     */
    @JvmName("uposxprwosrjirkt")
    public suspend fun transitions(`value`: List<BucketLifecycleRuleTransitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitions = mapped
    }

    /**
     * @param argument Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
     */
    @JvmName("khsmfjolejlgyobp")
    public suspend fun transitions(argument: List<suspend BucketLifecycleRuleTransitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param argument Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
     */
    @JvmName("quetudwlyohwdhrh")
    public suspend fun transitions(vararg argument: suspend BucketLifecycleRuleTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param argument Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
     */
    @JvmName("qpmwjkbnxjdqldtp")
    public suspend fun transitions(argument: suspend BucketLifecycleRuleTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketLifecycleRuleTransitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param values Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
     */
    @JvmName("ruwbbqlgjtlditpy")
    public suspend fun transitions(vararg values: BucketLifecycleRuleTransitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transitions = mapped
    }

    internal fun build(): BucketLifecycleRuleArgs = BucketLifecycleRuleArgs(
        abortMultipartUploads = abortMultipartUploads,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        expirations = expirations,
        filter = filter,
        id = id,
        noncurrentVersionExpirations = noncurrentVersionExpirations,
        noncurrentVersionTransitions = noncurrentVersionTransitions,
        prefix = prefix,
        tags = tags,
        transitions = transitions,
    )
}
