@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleExpirationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property createdBeforeDate Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
 * @property date Specifies the date after which you want the corresponding action to take effect. The value obeys ISO8601 format like `2017-03-09`.
 * @property days Specifies the number of days noncurrent object versions transition.
 * @property expiredObjectDeleteMarker On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct OSS to delete expired object delete markers. This cannot be specified with Days, Date or CreatedBeforeDate in a Lifecycle Expiration Policy.
 * `NOTE`: One and only one of "date", "days", "created_before_date" and "expired_object_delete_marker" can be specified in one expiration configuration.
 */
public data class BucketLifecycleRuleExpirationArgs(
    public val createdBeforeDate: Output<String>? = null,
    public val date: Output<String>? = null,
    public val days: Output<Int>? = null,
    public val expiredObjectDeleteMarker: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleExpirationArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleExpirationArgs =
        com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleExpirationArgs.builder()
            .createdBeforeDate(createdBeforeDate?.applyValue({ args0 -> args0 }))
            .date(date?.applyValue({ args0 -> args0 }))
            .days(days?.applyValue({ args0 -> args0 }))
            .expiredObjectDeleteMarker(expiredObjectDeleteMarker?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleRuleExpirationArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleExpirationArgsBuilder internal constructor() {
    private var createdBeforeDate: Output<String>? = null

    private var date: Output<String>? = null

    private var days: Output<Int>? = null

    private var expiredObjectDeleteMarker: Output<Boolean>? = null

    /**
     * @param value Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
     */
    @JvmName("nswcsgvwqnlegbtm")
    public suspend fun createdBeforeDate(`value`: Output<String>) {
        this.createdBeforeDate = value
    }

    /**
     * @param value Specifies the date after which you want the corresponding action to take effect. The value obeys ISO8601 format like `2017-03-09`.
     */
    @JvmName("pnqehgitnkoibdon")
    public suspend fun date(`value`: Output<String>) {
        this.date = value
    }

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("yaaxcsotjmygpyta")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct OSS to delete expired object delete markers. This cannot be specified with Days, Date or CreatedBeforeDate in a Lifecycle Expiration Policy.
     * `NOTE`: One and only one of "date", "days", "created_before_date" and "expired_object_delete_marker" can be specified in one expiration configuration.
     */
    @JvmName("lhguxjdkjqmnqyot")
    public suspend fun expiredObjectDeleteMarker(`value`: Output<Boolean>) {
        this.expiredObjectDeleteMarker = value
    }

    /**
     * @param value Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
     */
    @JvmName("arylbyuxcjjohmsn")
    public suspend fun createdBeforeDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdBeforeDate = mapped
    }

    /**
     * @param value Specifies the date after which you want the corresponding action to take effect. The value obeys ISO8601 format like `2017-03-09`.
     */
    @JvmName("xvvolansrtkuigqx")
    public suspend fun date(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.date = mapped
    }

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("ovmmapqhscaevqwt")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct OSS to delete expired object delete markers. This cannot be specified with Days, Date or CreatedBeforeDate in a Lifecycle Expiration Policy.
     * `NOTE`: One and only one of "date", "days", "created_before_date" and "expired_object_delete_marker" can be specified in one expiration configuration.
     */
    @JvmName("totjrhewpoyusbuh")
    public suspend fun expiredObjectDeleteMarker(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiredObjectDeleteMarker = mapped
    }

    internal fun build(): BucketLifecycleRuleExpirationArgs = BucketLifecycleRuleExpirationArgs(
        createdBeforeDate = createdBeforeDate,
        date = date,
        days = days,
        expiredObjectDeleteMarker = expiredObjectDeleteMarker,
    )
}
