@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property not The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
 * @property objectSizeGreaterThan Minimum object size (in bytes) to which the rule applies.
 * @property objectSizeLessThan Maximum object size (in bytes) to which the rule applies.
 */
public data class BucketLifecycleRuleFilterArgs(
    public val not: Output<BucketLifecycleRuleFilterNotArgs>? = null,
    public val objectSizeGreaterThan: Output<Int>? = null,
    public val objectSizeLessThan: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterArgs =
        com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterArgs.builder()
            .not(not?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .objectSizeGreaterThan(objectSizeGreaterThan?.applyValue({ args0 -> args0 }))
            .objectSizeLessThan(objectSizeLessThan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleRuleFilterArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleFilterArgsBuilder internal constructor() {
    private var not: Output<BucketLifecycleRuleFilterNotArgs>? = null

    private var objectSizeGreaterThan: Output<Int>? = null

    private var objectSizeLessThan: Output<Int>? = null

    /**
     * @param value The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
     */
    @JvmName("ttclqflyxadpevop")
    public suspend fun not(`value`: Output<BucketLifecycleRuleFilterNotArgs>) {
        this.not = value
    }

    /**
     * @param value Minimum object size (in bytes) to which the rule applies.
     */
    @JvmName("tbepstnibuflsvkv")
    public suspend fun objectSizeGreaterThan(`value`: Output<Int>) {
        this.objectSizeGreaterThan = value
    }

    /**
     * @param value Maximum object size (in bytes) to which the rule applies.
     */
    @JvmName("secuwpsvqacoloia")
    public suspend fun objectSizeLessThan(`value`: Output<Int>) {
        this.objectSizeLessThan = value
    }

    /**
     * @param value The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
     */
    @JvmName("kvhjfecwwkxrjskb")
    public suspend fun not(`value`: BucketLifecycleRuleFilterNotArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.not = mapped
    }

    /**
     * @param argument The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
     */
    @JvmName("rtepeeswhvuuxkao")
    public suspend fun not(argument: suspend BucketLifecycleRuleFilterNotArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleRuleFilterNotArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.not = mapped
    }

    /**
     * @param value Minimum object size (in bytes) to which the rule applies.
     */
    @JvmName("ygtxgclimrosoxqs")
    public suspend fun objectSizeGreaterThan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectSizeGreaterThan = mapped
    }

    /**
     * @param value Maximum object size (in bytes) to which the rule applies.
     */
    @JvmName("tkpwaspjtvahrwae")
    public suspend fun objectSizeLessThan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectSizeLessThan = mapped
    }

    internal fun build(): BucketLifecycleRuleFilterArgs = BucketLifecycleRuleFilterArgs(
        not = not,
        objectSizeGreaterThan = objectSizeGreaterThan,
        objectSizeLessThan = objectSizeLessThan,
    )
}
