@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterNotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property prefix The prefix in the names of the objects to which the lifecycle rule does not apply.
 * @property tag The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
 */
public data class BucketLifecycleRuleFilterNotArgs(
    public val prefix: Output<String>? = null,
    public val tag: Output<BucketLifecycleRuleFilterNotTagArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterNotArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterNotArgs =
        com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterNotArgs.builder()
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketLifecycleRuleFilterNotArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleFilterNotArgsBuilder internal constructor() {
    private var prefix: Output<String>? = null

    private var tag: Output<BucketLifecycleRuleFilterNotTagArgs>? = null

    /**
     * @param value The prefix in the names of the objects to which the lifecycle rule does not apply.
     */
    @JvmName("pnisjshisoarbwxq")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
     */
    @JvmName("ktheyhxstrbrwdtt")
    public suspend fun tag(`value`: Output<BucketLifecycleRuleFilterNotTagArgs>) {
        this.tag = value
    }

    /**
     * @param value The prefix in the names of the objects to which the lifecycle rule does not apply.
     */
    @JvmName("ngxriwflvmiibnit")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
     */
    @JvmName("lasxijtucctckqtc")
    public suspend fun tag(`value`: BucketLifecycleRuleFilterNotTagArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param argument The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
     */
    @JvmName("ertaeefirehrmdjx")
    public suspend fun tag(argument: suspend BucketLifecycleRuleFilterNotTagArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleRuleFilterNotTagArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tag = mapped
    }

    internal fun build(): BucketLifecycleRuleFilterNotArgs = BucketLifecycleRuleFilterNotArgs(
        prefix = prefix,
        tag = tag,
    )
}
