@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterNotTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The key of the tag that is specified for the objects.
 * @property value The value of the tag that is specified for the objects.
 */
public data class BucketLifecycleRuleFilterNotTagArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterNotTagArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterNotTagArgs =
        com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleFilterNotTagArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleRuleFilterNotTagArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleFilterNotTagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The key of the tag that is specified for the objects.
     */
    @JvmName("bxtbumdrugimcawe")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value of the tag that is specified for the objects.
     */
    @JvmName("rpngfybmwnmhdhvr")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The key of the tag that is specified for the objects.
     */
    @JvmName("dvjjrasxaxikjscv")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value of the tag that is specified for the objects.
     */
    @JvmName("rdfqsxramjxsmbhg")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): BucketLifecycleRuleFilterNotTagArgs = BucketLifecycleRuleFilterNotTagArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
