@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleNoncurrentVersionExpirationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property days Specifies the number of days noncurrent object versions transition.
 */
public data class BucketLifecycleRuleNoncurrentVersionExpirationArgs(
    public val days: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleNoncurrentVersionExpirationArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleNoncurrentVersionExpirationArgs =
        com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleNoncurrentVersionExpirationArgs.builder()
            .days(days.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleRuleNoncurrentVersionExpirationArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleNoncurrentVersionExpirationArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("movvnqypyympvxlq")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("jwsxguvrcjgdtsoy")
    public suspend fun days(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.days = mapped
    }

    internal fun build(): BucketLifecycleRuleNoncurrentVersionExpirationArgs =
        BucketLifecycleRuleNoncurrentVersionExpirationArgs(
            days = days ?: throw PulumiNullFieldException("days"),
        )
}
