@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleNoncurrentVersionTransitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property days Specifies the number of days noncurrent object versions transition.
 * @property isAccessTime Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
 * @property returnToStdWhenVisit Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
 * @property storageClass The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
 */
public data class BucketLifecycleRuleNoncurrentVersionTransitionArgs(
    public val days: Output<Int>,
    public val isAccessTime: Output<Boolean>? = null,
    public val returnToStdWhenVisit: Output<Boolean>? = null,
    public val storageClass: Output<String>,
) :
    ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleNoncurrentVersionTransitionArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleNoncurrentVersionTransitionArgs =
        com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleNoncurrentVersionTransitionArgs.builder()
            .days(days.applyValue({ args0 -> args0 }))
            .isAccessTime(isAccessTime?.applyValue({ args0 -> args0 }))
            .returnToStdWhenVisit(returnToStdWhenVisit?.applyValue({ args0 -> args0 }))
            .storageClass(storageClass.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleRuleNoncurrentVersionTransitionArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    private var isAccessTime: Output<Boolean>? = null

    private var returnToStdWhenVisit: Output<Boolean>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("qjvivxpsocdgengo")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
     */
    @JvmName("ccirgllitxmiglxn")
    public suspend fun isAccessTime(`value`: Output<Boolean>) {
        this.isAccessTime = value
    }

    /**
     * @param value Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
     */
    @JvmName("anoevvwatrrygbeq")
    public suspend fun returnToStdWhenVisit(`value`: Output<Boolean>) {
        this.returnToStdWhenVisit = value
    }

    /**
     * @param value The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
     */
    @JvmName("qytxwruwnjxlkmqn")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("xvctxrpjyaynwbkk")
    public suspend fun days(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
     */
    @JvmName("okopwqncfkhfypml")
    public suspend fun isAccessTime(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAccessTime = mapped
    }

    /**
     * @param value Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
     */
    @JvmName("qwxvtpkrqralupua")
    public suspend fun returnToStdWhenVisit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.returnToStdWhenVisit = mapped
    }

    /**
     * @param value The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
     */
    @JvmName("wgqyikfqbvmrvfle")
    public suspend fun storageClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): BucketLifecycleRuleNoncurrentVersionTransitionArgs =
        BucketLifecycleRuleNoncurrentVersionTransitionArgs(
            days = days ?: throw PulumiNullFieldException("days"),
            isAccessTime = isAccessTime,
            returnToStdWhenVisit = returnToStdWhenVisit,
            storageClass = storageClass ?: throw PulumiNullFieldException("storageClass"),
        )
}
