@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleTransitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property createdBeforeDate Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
 * @property days Specifies the number of days noncurrent object versions transition.
 * @property isAccessTime Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
 * @property returnToStdWhenVisit Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
 * @property storageClass The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
 */
public data class BucketLifecycleRuleTransitionArgs(
    public val createdBeforeDate: Output<String>? = null,
    public val days: Output<Int>? = null,
    public val isAccessTime: Output<Boolean>? = null,
    public val returnToStdWhenVisit: Output<Boolean>? = null,
    public val storageClass: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleTransitionArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleTransitionArgs =
        com.pulumi.alicloud.oss.inputs.BucketLifecycleRuleTransitionArgs.builder()
            .createdBeforeDate(createdBeforeDate?.applyValue({ args0 -> args0 }))
            .days(days?.applyValue({ args0 -> args0 }))
            .isAccessTime(isAccessTime?.applyValue({ args0 -> args0 }))
            .returnToStdWhenVisit(returnToStdWhenVisit?.applyValue({ args0 -> args0 }))
            .storageClass(storageClass.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleRuleTransitionArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleTransitionArgsBuilder internal constructor() {
    private var createdBeforeDate: Output<String>? = null

    private var days: Output<Int>? = null

    private var isAccessTime: Output<Boolean>? = null

    private var returnToStdWhenVisit: Output<Boolean>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
     */
    @JvmName("gpmhvyysxrdtujfx")
    public suspend fun createdBeforeDate(`value`: Output<String>) {
        this.createdBeforeDate = value
    }

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("coentyxtqybmqxvi")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
     */
    @JvmName("sabnbcghhdkmhnvd")
    public suspend fun isAccessTime(`value`: Output<Boolean>) {
        this.isAccessTime = value
    }

    /**
     * @param value Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
     */
    @JvmName("etaxkeqjelmsaefb")
    public suspend fun returnToStdWhenVisit(`value`: Output<Boolean>) {
        this.returnToStdWhenVisit = value
    }

    /**
     * @param value The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
     */
    @JvmName("ijwocgepilyxiakp")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
     */
    @JvmName("pmxqeymnssbgsbal")
    public suspend fun createdBeforeDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdBeforeDate = mapped
    }

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("ppamcncartaljygp")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
     */
    @JvmName("delgehmwxqgfsuwf")
    public suspend fun isAccessTime(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAccessTime = mapped
    }

    /**
     * @param value Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
     */
    @JvmName("dugedwwyyhcnemey")
    public suspend fun returnToStdWhenVisit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.returnToStdWhenVisit = mapped
    }

    /**
     * @param value The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
     */
    @JvmName("wbaxlwgmvnqejsdn")
    public suspend fun storageClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): BucketLifecycleRuleTransitionArgs = BucketLifecycleRuleTransitionArgs(
        createdBeforeDate = createdBeforeDate,
        days = days,
        isAccessTime = isAccessTime,
        returnToStdWhenVisit = returnToStdWhenVisit,
        storageClass = storageClass ?: throw PulumiNullFieldException("storageClass"),
    )
}
