@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketRefererConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowEmpty Allows referer to be empty. Defaults false.
 * @property referers The list of referer.
 */
public data class BucketRefererConfigArgs(
    public val allowEmpty: Output<Boolean>? = null,
    public val referers: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketRefererConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketRefererConfigArgs =
        com.pulumi.alicloud.oss.inputs.BucketRefererConfigArgs.builder()
            .allowEmpty(allowEmpty?.applyValue({ args0 -> args0 }))
            .referers(referers.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BucketRefererConfigArgs].
 */
@PulumiTagMarker
public class BucketRefererConfigArgsBuilder internal constructor() {
    private var allowEmpty: Output<Boolean>? = null

    private var referers: Output<List<String>>? = null

    /**
     * @param value Allows referer to be empty. Defaults false.
     */
    @JvmName("mlagkbwubftpgtid")
    public suspend fun allowEmpty(`value`: Output<Boolean>) {
        this.allowEmpty = value
    }

    /**
     * @param value The list of referer.
     */
    @JvmName("lccfohfwxwkdxmcp")
    public suspend fun referers(`value`: Output<List<String>>) {
        this.referers = value
    }

    @JvmName("nxodmpigyrouspbb")
    public suspend fun referers(vararg values: Output<String>) {
        this.referers = Output.all(values.asList())
    }

    /**
     * @param values The list of referer.
     */
    @JvmName("yntobruysrhkkqvi")
    public suspend fun referers(values: List<Output<String>>) {
        this.referers = Output.all(values)
    }

    /**
     * @param value Allows referer to be empty. Defaults false.
     */
    @JvmName("uavhpmnwhrucwcvb")
    public suspend fun allowEmpty(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowEmpty = mapped
    }

    /**
     * @param value The list of referer.
     */
    @JvmName("tjkwyjrgfooschgq")
    public suspend fun referers(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referers = mapped
    }

    /**
     * @param values The list of referer.
     */
    @JvmName("fyapayiymjcqaugi")
    public suspend fun referers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referers = mapped
    }

    internal fun build(): BucketRefererConfigArgs = BucketRefererConfigArgs(
        allowEmpty = allowEmpty,
        referers = referers ?: throw PulumiNullFieldException("referers"),
    )
}
