@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketReplicationDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket The destination bucket to which the data is replicated.
 * @property location The region in which the destination bucket is located.
 * @property transferType The link used to transfer data in data replication.. Can be `internal` or `oss_acc`. Defaults to `internal`.
 * `NOTE`: You can set transfer_type to oss_acc only when you create cross-region replication (CRR) rules.
 */
public data class BucketReplicationDestinationArgs(
    public val bucket: Output<String>,
    public val location: Output<String>,
    public val transferType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketReplicationDestinationArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketReplicationDestinationArgs =
        com.pulumi.alicloud.oss.inputs.BucketReplicationDestinationArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .location(location.applyValue({ args0 -> args0 }))
            .transferType(transferType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationDestinationArgs].
 */
@PulumiTagMarker
public class BucketReplicationDestinationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var location: Output<String>? = null

    private var transferType: Output<String>? = null

    /**
     * @param value The destination bucket to which the data is replicated.
     */
    @JvmName("irpeboutfbldnjlb")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The region in which the destination bucket is located.
     */
    @JvmName("shikkwaahxpdgnwb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The link used to transfer data in data replication.. Can be `internal` or `oss_acc`. Defaults to `internal`.
     * `NOTE`: You can set transfer_type to oss_acc only when you create cross-region replication (CRR) rules.
     */
    @JvmName("otslppxilcngukhc")
    public suspend fun transferType(`value`: Output<String>) {
        this.transferType = value
    }

    /**
     * @param value The destination bucket to which the data is replicated.
     */
    @JvmName("kepkcpsmjlglyhnj")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The region in which the destination bucket is located.
     */
    @JvmName("btkisjwwkowbcliw")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The link used to transfer data in data replication.. Can be `internal` or `oss_acc`. Defaults to `internal`.
     * `NOTE`: You can set transfer_type to oss_acc only when you create cross-region replication (CRR) rules.
     */
    @JvmName("rjpsnwpndvjbusxc")
    public suspend fun transferType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferType = mapped
    }

    internal fun build(): BucketReplicationDestinationArgs = BucketReplicationDestinationArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        location = location ?: throw PulumiNullFieldException("location"),
        transferType = transferType,
    )
}
