@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketReplicationEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property replicaKmsKeyId The CMK ID used in SSE-KMS.
 * `NOTE`: If the status of sse_kms_encrypted_objects is set to Enabled, you must specify the replica_kms_key_id.
 */
public data class BucketReplicationEncryptionConfigurationArgs(
    public val replicaKmsKeyId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketReplicationEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketReplicationEncryptionConfigurationArgs = com.pulumi.alicloud.oss.inputs.BucketReplicationEncryptionConfigurationArgs.builder()
        .replicaKmsKeyId(replicaKmsKeyId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class BucketReplicationEncryptionConfigurationArgsBuilder internal constructor() {
    private var replicaKmsKeyId: Output<String>? = null

    /**
     * @param value The CMK ID used in SSE-KMS.
     * `NOTE`: If the status of sse_kms_encrypted_objects is set to Enabled, you must specify the replica_kms_key_id.
     */
    @JvmName("piudvemhmixuxygl")
    public suspend fun replicaKmsKeyId(`value`: Output<String>) {
        this.replicaKmsKeyId = value
    }

    /**
     * @param value The CMK ID used in SSE-KMS.
     * `NOTE`: If the status of sse_kms_encrypted_objects is set to Enabled, you must specify the replica_kms_key_id.
     */
    @JvmName("vngngonwrgcqjqwr")
    public suspend fun replicaKmsKeyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicaKmsKeyId = mapped
    }

    internal fun build(): BucketReplicationEncryptionConfigurationArgs =
        BucketReplicationEncryptionConfigurationArgs(
            replicaKmsKeyId = replicaKmsKeyId ?: throw PulumiNullFieldException("replicaKmsKeyId"),
        )
}
