@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketReplicationPrefixSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property prefixes The list of object key name prefix identifying one or more objects to which the rule applies.
 * `NOTE`: The prefix must be less than or equal to 1024 characters in length.
 */
public data class BucketReplicationPrefixSetArgs(
    public val prefixes: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketReplicationPrefixSetArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketReplicationPrefixSetArgs =
        com.pulumi.alicloud.oss.inputs.BucketReplicationPrefixSetArgs.builder()
            .prefixes(prefixes.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BucketReplicationPrefixSetArgs].
 */
@PulumiTagMarker
public class BucketReplicationPrefixSetArgsBuilder internal constructor() {
    private var prefixes: Output<List<String>>? = null

    /**
     * @param value The list of object key name prefix identifying one or more objects to which the rule applies.
     * `NOTE`: The prefix must be less than or equal to 1024 characters in length.
     */
    @JvmName("gffqaaedkhcyyklp")
    public suspend fun prefixes(`value`: Output<List<String>>) {
        this.prefixes = value
    }

    @JvmName("aeuxtbarwsxxahlv")
    public suspend fun prefixes(vararg values: Output<String>) {
        this.prefixes = Output.all(values.asList())
    }

    /**
     * @param values The list of object key name prefix identifying one or more objects to which the rule applies.
     * `NOTE`: The prefix must be less than or equal to 1024 characters in length.
     */
    @JvmName("ytungmfduclnimou")
    public suspend fun prefixes(values: List<Output<String>>) {
        this.prefixes = Output.all(values)
    }

    /**
     * @param value The list of object key name prefix identifying one or more objects to which the rule applies.
     * `NOTE`: The prefix must be less than or equal to 1024 characters in length.
     */
    @JvmName("ishdsmjyxnfrkxyc")
    public suspend fun prefixes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixes = mapped
    }

    /**
     * @param values The list of object key name prefix identifying one or more objects to which the rule applies.
     * `NOTE`: The prefix must be less than or equal to 1024 characters in length.
     */
    @JvmName("bcdllpqbgdtpbjpm")
    public suspend fun prefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixes = mapped
    }

    internal fun build(): BucketReplicationPrefixSetArgs = BucketReplicationPrefixSetArgs(
        prefixes = prefixes ?: throw PulumiNullFieldException("prefixes"),
    )
}
