@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketReplicationProgressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property historicalObject The percentage of the replicated historical data. This element is valid only when historical_object_replication is set to enabled.
 * @property newObject The time used to distinguish new data from historical data. Data that is written to the source bucket before the time is replicated to the destination bucket as new data. The value of this element is in GMT.
 */
public data class BucketReplicationProgressArgs(
    public val historicalObject: Output<String>? = null,
    public val newObject: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketReplicationProgressArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketReplicationProgressArgs =
        com.pulumi.alicloud.oss.inputs.BucketReplicationProgressArgs.builder()
            .historicalObject(historicalObject?.applyValue({ args0 -> args0 }))
            .newObject(newObject?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationProgressArgs].
 */
@PulumiTagMarker
public class BucketReplicationProgressArgsBuilder internal constructor() {
    private var historicalObject: Output<String>? = null

    private var newObject: Output<String>? = null

    /**
     * @param value The percentage of the replicated historical data. This element is valid only when historical_object_replication is set to enabled.
     */
    @JvmName("gpdmgspatvxdgpqr")
    public suspend fun historicalObject(`value`: Output<String>) {
        this.historicalObject = value
    }

    /**
     * @param value The time used to distinguish new data from historical data. Data that is written to the source bucket before the time is replicated to the destination bucket as new data. The value of this element is in GMT.
     */
    @JvmName("jgidaoyxstcfuena")
    public suspend fun newObject(`value`: Output<String>) {
        this.newObject = value
    }

    /**
     * @param value The percentage of the replicated historical data. This element is valid only when historical_object_replication is set to enabled.
     */
    @JvmName("fmxhkytckqrhuvvf")
    public suspend fun historicalObject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.historicalObject = mapped
    }

    /**
     * @param value The time used to distinguish new data from historical data. Data that is written to the source bucket before the time is replicated to the destination bucket as new data. The value of this element is in GMT.
     */
    @JvmName("ugniuexurqpmcacs")
    public suspend fun newObject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newObject = mapped
    }

    internal fun build(): BucketReplicationProgressArgs = BucketReplicationProgressArgs(
        historicalObject = historicalObject,
        newObject = newObject,
    )
}
