@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketReplicationSourceSelectionCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sseKmsEncryptedObjects Filter source objects encrypted by using SSE-KMS. See `sse_kms_encrypted_objects` below.
 */
public data class BucketReplicationSourceSelectionCriteriaArgs(
    public val sseKmsEncryptedObjects: Output<BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketReplicationSourceSelectionCriteriaArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketReplicationSourceSelectionCriteriaArgs = com.pulumi.alicloud.oss.inputs.BucketReplicationSourceSelectionCriteriaArgs.builder()
        .sseKmsEncryptedObjects(
            sseKmsEncryptedObjects?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [BucketReplicationSourceSelectionCriteriaArgs].
 */
@PulumiTagMarker
public class BucketReplicationSourceSelectionCriteriaArgsBuilder internal constructor() {
    private var sseKmsEncryptedObjects:
        Output<BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs>? = null

    /**
     * @param value Filter source objects encrypted by using SSE-KMS. See `sse_kms_encrypted_objects` below.
     */
    @JvmName("qabyuqflpciuffry")
    public suspend fun sseKmsEncryptedObjects(`value`: Output<BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs>) {
        this.sseKmsEncryptedObjects = value
    }

    /**
     * @param value Filter source objects encrypted by using SSE-KMS. See `sse_kms_encrypted_objects` below.
     */
    @JvmName("djhiqdvbnjxmxejf")
    public suspend fun sseKmsEncryptedObjects(`value`: BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseKmsEncryptedObjects = mapped
    }

    /**
     * @param argument Filter source objects encrypted by using SSE-KMS. See `sse_kms_encrypted_objects` below.
     */
    @JvmName("twqnwugphkqeqdrl")
    public suspend fun sseKmsEncryptedObjects(argument: suspend BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sseKmsEncryptedObjects = mapped
    }

    internal fun build(): BucketReplicationSourceSelectionCriteriaArgs =
        BucketReplicationSourceSelectionCriteriaArgs(
            sseKmsEncryptedObjects = sseKmsEncryptedObjects,
        )
}
