@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketServerSideEncryptionRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsMasterKeyId The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
 * @property sseAlgorithm The server-side encryption algorithm to use. Possible values: `AES256` and `KMS`.
 */
public data class BucketServerSideEncryptionRuleArgs(
    public val kmsMasterKeyId: Output<String>? = null,
    public val sseAlgorithm: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketServerSideEncryptionRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketServerSideEncryptionRuleArgs =
        com.pulumi.alicloud.oss.inputs.BucketServerSideEncryptionRuleArgs.builder()
            .kmsMasterKeyId(kmsMasterKeyId?.applyValue({ args0 -> args0 }))
            .sseAlgorithm(sseAlgorithm.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketServerSideEncryptionRuleArgs].
 */
@PulumiTagMarker
public class BucketServerSideEncryptionRuleArgsBuilder internal constructor() {
    private var kmsMasterKeyId: Output<String>? = null

    private var sseAlgorithm: Output<String>? = null

    /**
     * @param value The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
     */
    @JvmName("aolhjupahexhmnbq")
    public suspend fun kmsMasterKeyId(`value`: Output<String>) {
        this.kmsMasterKeyId = value
    }

    /**
     * @param value The server-side encryption algorithm to use. Possible values: `AES256` and `KMS`.
     */
    @JvmName("homnxwvedghypdmw")
    public suspend fun sseAlgorithm(`value`: Output<String>) {
        this.sseAlgorithm = value
    }

    /**
     * @param value The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
     */
    @JvmName("sjkaggtnyfcnqylk")
    public suspend fun kmsMasterKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsMasterKeyId = mapped
    }

    /**
     * @param value The server-side encryption algorithm to use. Possible values: `AES256` and `KMS`.
     */
    @JvmName("wvdjebqoaxwkcdra")
    public suspend fun sseAlgorithm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sseAlgorithm = mapped
    }

    internal fun build(): BucketServerSideEncryptionRuleArgs = BucketServerSideEncryptionRuleArgs(
        kmsMasterKeyId = kmsMasterKeyId,
        sseAlgorithm = sseAlgorithm ?: throw PulumiNullFieldException("sseAlgorithm"),
    )
}
