@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketTransferAccelerationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Specifies the accelerate status of a bucket.
 */
public data class BucketTransferAccelerationArgs(
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketTransferAccelerationArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketTransferAccelerationArgs =
        com.pulumi.alicloud.oss.inputs.BucketTransferAccelerationArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketTransferAccelerationArgs].
 */
@PulumiTagMarker
public class BucketTransferAccelerationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Specifies the accelerate status of a bucket.
     */
    @JvmName("xgnloygkujaeollc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies the accelerate status of a bucket.
     */
    @JvmName("fjxqsjqvieshilpw")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): BucketTransferAccelerationArgs = BucketTransferAccelerationArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
    )
}
