@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketVersioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Specifies the versioning state of a bucket. Valid values: `Enabled` and `Suspended`.
 */
public data class BucketVersioningArgs(
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketVersioningArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketVersioningArgs =
        com.pulumi.alicloud.oss.inputs.BucketVersioningArgs.builder()
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketVersioningArgs].
 */
@PulumiTagMarker
public class BucketVersioningArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Specifies the versioning state of a bucket. Valid values: `Enabled` and `Suspended`.
     */
    @JvmName("edfjvbckpruyvfac")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Specifies the versioning state of a bucket. Valid values: `Enabled` and `Suspended`.
     */
    @JvmName("qqrknjakwbiqpeki")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketVersioningArgs = BucketVersioningArgs(
        status = status ?: throw PulumiNullFieldException("status"),
    )
}
