@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketWebsiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property errorDocument An absolute path to the document to return in case of a 4XX error.
 * @property indexDocument Alicloud OSS returns this index document when requests are made to the root domain or any of the subfolders.
 */
public data class BucketWebsiteArgs(
    public val errorDocument: Output<String>? = null,
    public val indexDocument: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketWebsiteArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketWebsiteArgs =
        com.pulumi.alicloud.oss.inputs.BucketWebsiteArgs.builder()
            .errorDocument(errorDocument?.applyValue({ args0 -> args0 }))
            .indexDocument(indexDocument.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketWebsiteArgs].
 */
@PulumiTagMarker
public class BucketWebsiteArgsBuilder internal constructor() {
    private var errorDocument: Output<String>? = null

    private var indexDocument: Output<String>? = null

    /**
     * @param value An absolute path to the document to return in case of a 4XX error.
     */
    @JvmName("yempcjnlpgbmunjr")
    public suspend fun errorDocument(`value`: Output<String>) {
        this.errorDocument = value
    }

    /**
     * @param value Alicloud OSS returns this index document when requests are made to the root domain or any of the subfolders.
     */
    @JvmName("irvmdubhfxhkdjtp")
    public suspend fun indexDocument(`value`: Output<String>) {
        this.indexDocument = value
    }

    /**
     * @param value An absolute path to the document to return in case of a 4XX error.
     */
    @JvmName("qlgtrrtujcemmjwt")
    public suspend fun errorDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorDocument = mapped
    }

    /**
     * @param value Alicloud OSS returns this index document when requests are made to the root domain or any of the subfolders.
     */
    @JvmName("eoirfehmvlvadoro")
    public suspend fun indexDocument(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexDocument = mapped
    }

    internal fun build(): BucketWebsiteArgs = BucketWebsiteArgs(
        errorDocument = errorDocument,
        indexDocument = indexDocument ?: throw PulumiNullFieldException("indexDocument"),
    )
}
