@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.GetBucketObjectsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBucketObjects.
 * @property bucketName Name of the bucket that contains the objects to find.
 * @property keyPrefix Filter results by the given key prefix (such as "path/to/folder/logs-").
 * @property keyRegex A regex string to filter results by key.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetBucketObjectsPlainArgs(
    public val bucketName: String,
    public val keyPrefix: String? = null,
    public val keyRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.GetBucketObjectsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.GetBucketObjectsPlainArgs =
        com.pulumi.alicloud.oss.inputs.GetBucketObjectsPlainArgs.builder()
            .bucketName(bucketName.let({ args0 -> args0 }))
            .keyPrefix(keyPrefix?.let({ args0 -> args0 }))
            .keyRegex(keyRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBucketObjectsPlainArgs].
 */
@PulumiTagMarker
public class GetBucketObjectsPlainArgsBuilder internal constructor() {
    private var bucketName: String? = null

    private var keyPrefix: String? = null

    private var keyRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value Name of the bucket that contains the objects to find.
     */
    @JvmName("gngfdgiklsnteoxo")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bucketName = mapped
    }

    /**
     * @param value Filter results by the given key prefix (such as "path/to/folder/logs-").
     */
    @JvmName("wcrhipmkvnuipylt")
    public suspend fun keyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyPrefix = mapped
    }

    /**
     * @param value A regex string to filter results by key.
     */
    @JvmName("ummxmufvhkunggiu")
    public suspend fun keyRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pkwmbvvyquedtcjk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetBucketObjectsPlainArgs = GetBucketObjectsPlainArgs(
        bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        keyPrefix = keyPrefix,
        keyRegex = keyRegex,
        outputFile = outputFile,
    )
}
