@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.GetBucketsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBuckets.
 * @property nameRegex A regex string to filter results by bucket name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetBucketsPlainArgs(
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.GetBucketsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.GetBucketsPlainArgs =
        com.pulumi.alicloud.oss.inputs.GetBucketsPlainArgs.builder()
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBucketsPlainArgs].
 */
@PulumiTagMarker
public class GetBucketsPlainArgsBuilder internal constructor() {
    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A regex string to filter results by bucket name.
     */
    @JvmName("rnuwnytapeauoijv")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kdqbuhljbcgiatwb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetBucketsPlainArgs = GetBucketsPlainArgs(
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
