@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.GetInstanceAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceAttachments.
 * @property instanceName The name of OTS instance.
 * @property nameRegex A regex string to filter results by vpc name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetInstanceAttachmentsPlainArgs(
    public val instanceName: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.GetInstanceAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.GetInstanceAttachmentsPlainArgs =
        com.pulumi.alicloud.oss.inputs.GetInstanceAttachmentsPlainArgs.builder()
            .instanceName(instanceName.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceAttachmentsPlainArgsBuilder internal constructor() {
    private var instanceName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The name of OTS instance.
     */
    @JvmName("mlnkienjvabqgieb")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value A regex string to filter results by vpc name.
     */
    @JvmName("sbyifylhqhchjtql")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("uavlcuibqrxfnggq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetInstanceAttachmentsPlainArgs = GetInstanceAttachmentsPlainArgs(
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
