@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property ids A list of instance IDs.
 * @property nameRegex A regex string to filter results by instance name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property tags A map of tags assigned to the instance. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const instancesDs = alicloud.ots.getInstances({
 *     tags: {
 *         tagKey1: "tagValue1",
 *         tagKey2: "tagValue2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * instances_ds = alicloud.ots.get_instances(tags={
 *     "tagKey1": "tagValue1",
 *     "tagKey2": "tagValue2",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instancesDs = AliCloud.Ots.GetInstances.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *             { "tagKey2", "tagValue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ots.GetInstances(ctx, &ots.GetInstancesArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 				"tagKey2": "tagValue2",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ots.OtsFunctions;
 * import com.pulumi.alicloud.ots.inputs.GetInstancesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var instancesDs = OtsFunctions.getInstances(GetInstancesArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tagValue1"),
 *                 Map.entry("tagKey2", "tagValue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   instancesDs:
 *     fn::invoke:
 *       Function: alicloud:ots:getInstances
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 *           tagKey2: tagValue2
 * ```
 * <!--End PulumiCodeChooser -->
 */
public data class GetInstancesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.oss.inputs.GetInstancesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A list of instance IDs.
     */
    @JvmName("xwtlfmnficjkspwf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of instance IDs.
     */
    @JvmName("yahlfhcbboutdanr")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by instance name.
     */
    @JvmName("jtlnuvafqtagfrjs")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ltcwstqxrfrqmqmk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value A map of tags assigned to the instance. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const instancesDs = alicloud.ots.getInstances({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instances_ds = alicloud.ots.get_instances(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instancesDs = AliCloud.Ots.GetInstances.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ots.GetInstances(ctx, &ots.GetInstancesArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ots.OtsFunctions;
     * import com.pulumi.alicloud.ots.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instancesDs = OtsFunctions.getInstances(GetInstancesArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instancesDs:
     *     fn::invoke:
     *       Function: alicloud:ots:getInstances
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("wbbhkbhrpouprgdu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the instance. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const instancesDs = alicloud.ots.getInstances({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instances_ds = alicloud.ots.get_instances(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instancesDs = AliCloud.Ots.GetInstances.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ots.GetInstances(ctx, &ots.GetInstancesArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ots.OtsFunctions;
     * import com.pulumi.alicloud.ots.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instancesDs = OtsFunctions.getInstances(GetInstancesArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instancesDs:
     *     fn::invoke:
     *       Function: alicloud:ots:getInstances
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("ttnasyudintyfcfu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        tags = tags,
    )
}
