@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowedHeaders Specifies whether the headers specified by Access-Control-Request-Headers in the OPTIONS preflight request are allowed. You can use only one asterisk (*) as the wildcard for allowed header. .
 * @property allowedMethods The cross-origin request method that is allowed. Valid values: GET, PUT, DELETE, POST, and HEAD.
 * @property allowedOrigins The origins from which cross-origin requests are allowed. .
 * @property exposeHeaders The response headers for allowed access requests from applications, such as an XMLHttpRequest object in JavaScript. .
 * @property maxAgeSeconds The period of time within which the browser can cache the response to an OPTIONS preflight request for the specified resource. Unit: seconds.
 */
public data class BucketCorsCorsRule(
    public val allowedHeaders: List<String>? = null,
    public val allowedMethods: List<String>,
    public val allowedOrigins: List<String>? = null,
    public val exposeHeaders: List<String>? = null,
    public val maxAgeSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketCorsCorsRule): BucketCorsCorsRule = BucketCorsCorsRule(
            allowedHeaders = javaType.allowedHeaders().map({ args0 -> args0 }),
            allowedMethods = javaType.allowedMethods().map({ args0 -> args0 }),
            allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
            exposeHeaders = javaType.exposeHeaders().map({ args0 -> args0 }),
            maxAgeSeconds = javaType.maxAgeSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
