@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowedHeaders Specifies which headers are allowed.
 * @property allowedMethods Specifies which methods are allowed. Can be GET, PUT, POST, DELETE or HEAD.
 * @property allowedOrigins Specifies which origins are allowed.
 * @property exposeHeaders Specifies expose header in the response.
 * @property maxAgeSeconds Specifies time in seconds that browser can cache the response for a preflight request.
 */
public data class BucketCorsRule(
    public val allowedHeaders: List<String>? = null,
    public val allowedMethods: List<String>,
    public val allowedOrigins: List<String>,
    public val exposeHeaders: List<String>? = null,
    public val maxAgeSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketCorsRule): BucketCorsRule =
            BucketCorsRule(
                allowedHeaders = javaType.allowedHeaders().map({ args0 -> args0 }),
                allowedMethods = javaType.allowedMethods().map({ args0 -> args0 }),
                allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
                exposeHeaders = javaType.exposeHeaders().map({ args0 -> args0 }),
                maxAgeSeconds = javaType.maxAgeSeconds().map({ args0 -> args0 }).orElse(null),
            )
    }
}
