@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property abortMultipartUploads Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
 * @property enabled Specifies lifecycle rule status.
 * @property expirations Specifies a period in the object's expire. See `expiration` below.
 * @property filter Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.
 * `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
 * @property id Unique identifier for the rule. If omitted, OSS bucket will assign a unique name.
 * @property noncurrentVersionExpirations Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
 * @property noncurrentVersionTransitions Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
 * @property prefix The prefix in the names of the objects to which the lifecycle rule does not apply.
 * @property tags Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
 * @property transitions Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
 */
public data class BucketLifecycleRule(
    public val abortMultipartUploads: List<BucketLifecycleRuleAbortMultipartUpload>? = null,
    public val enabled: Boolean,
    public val expirations: List<BucketLifecycleRuleExpiration>? = null,
    public val filter: BucketLifecycleRuleFilter? = null,
    public val id: String? = null,
    public val noncurrentVersionExpirations: List<BucketLifecycleRuleNoncurrentVersionExpiration>? =
        null,
    public val noncurrentVersionTransitions: List<BucketLifecycleRuleNoncurrentVersionTransition>? =
        null,
    public val prefix: String? = null,
    public val tags: Map<String, String>? = null,
    public val transitions: List<BucketLifecycleRuleTransition>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketLifecycleRule): BucketLifecycleRule = BucketLifecycleRule(
            abortMultipartUploads = javaType.abortMultipartUploads().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.BucketLifecycleRuleAbortMultipartUpload.Companion.toKotlin(args0)
                })
            }),
            enabled = javaType.enabled(),
            expirations = javaType.expirations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.BucketLifecycleRuleExpiration.Companion.toKotlin(args0)
                })
            }),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.BucketLifecycleRuleFilter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            noncurrentVersionExpirations = javaType.noncurrentVersionExpirations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.BucketLifecycleRuleNoncurrentVersionExpiration.Companion.toKotlin(args0)
                })
            }),
            noncurrentVersionTransitions = javaType.noncurrentVersionTransitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.BucketLifecycleRuleNoncurrentVersionTransition.Companion.toKotlin(args0)
                })
            }),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitions = javaType.transitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.BucketLifecycleRuleTransition.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
