@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createdBeforeDate Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
 * @property days Specifies the number of days noncurrent object versions transition.
 */
public data class BucketLifecycleRuleAbortMultipartUpload(
    public val createdBeforeDate: String? = null,
    public val days: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketLifecycleRuleAbortMultipartUpload): BucketLifecycleRuleAbortMultipartUpload = BucketLifecycleRuleAbortMultipartUpload(
            createdBeforeDate = javaType.createdBeforeDate().map({ args0 -> args0 }).orElse(null),
            days = javaType.days().map({ args0 -> args0 }).orElse(null),
        )
    }
}
