@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createdBeforeDate Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
 * @property date Specifies the date after which you want the corresponding action to take effect. The value obeys ISO8601 format like `2017-03-09`.
 * @property days Specifies the number of days noncurrent object versions transition.
 * @property expiredObjectDeleteMarker On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct OSS to delete expired object delete markers. This cannot be specified with Days, Date or CreatedBeforeDate in a Lifecycle Expiration Policy.
 * `NOTE`: One and only one of "date", "days", "created_before_date" and "expired_object_delete_marker" can be specified in one expiration configuration.
 */
public data class BucketLifecycleRuleExpiration(
    public val createdBeforeDate: String? = null,
    public val date: String? = null,
    public val days: Int? = null,
    public val expiredObjectDeleteMarker: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketLifecycleRuleExpiration): BucketLifecycleRuleExpiration = BucketLifecycleRuleExpiration(
            createdBeforeDate = javaType.createdBeforeDate().map({ args0 -> args0 }).orElse(null),
            date = javaType.date().map({ args0 -> args0 }).orElse(null),
            days = javaType.days().map({ args0 -> args0 }).orElse(null),
            expiredObjectDeleteMarker = javaType.expiredObjectDeleteMarker().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
