@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property not The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
 * @property objectSizeGreaterThan Minimum object size (in bytes) to which the rule applies.
 * @property objectSizeLessThan Maximum object size (in bytes) to which the rule applies.
 */
public data class BucketLifecycleRuleFilter(
    public val not: BucketLifecycleRuleFilterNot? = null,
    public val objectSizeGreaterThan: Int? = null,
    public val objectSizeLessThan: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketLifecycleRuleFilter): BucketLifecycleRuleFilter = BucketLifecycleRuleFilter(
            not = javaType.not().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.BucketLifecycleRuleFilterNot.Companion.toKotlin(args0)
                })
            }).orElse(null),
            objectSizeGreaterThan = javaType.objectSizeGreaterThan().map({ args0 -> args0 }).orElse(null),
            objectSizeLessThan = javaType.objectSizeLessThan().map({ args0 -> args0 }).orElse(null),
        )
    }
}
