@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property prefix The prefix in the names of the objects to which the lifecycle rule does not apply.
 * @property tag The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
 */
public data class BucketLifecycleRuleFilterNot(
    public val prefix: String? = null,
    public val tag: BucketLifecycleRuleFilterNotTag? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketLifecycleRuleFilterNot): BucketLifecycleRuleFilterNot = BucketLifecycleRuleFilterNot(
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.BucketLifecycleRuleFilterNotTag.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
