@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property days Specifies the number of days noncurrent object versions transition.
 * @property isAccessTime Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
 * @property returnToStdWhenVisit Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
 * @property storageClass The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
 */
public data class BucketLifecycleRuleNoncurrentVersionTransition(
    public val days: Int,
    public val isAccessTime: Boolean? = null,
    public val returnToStdWhenVisit: Boolean? = null,
    public val storageClass: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketLifecycleRuleNoncurrentVersionTransition): BucketLifecycleRuleNoncurrentVersionTransition =
            BucketLifecycleRuleNoncurrentVersionTransition(
                days = javaType.days(),
                isAccessTime = javaType.isAccessTime().map({ args0 -> args0 }).orElse(null),
                returnToStdWhenVisit = javaType.returnToStdWhenVisit().map({ args0 -> args0 }).orElse(null),
                storageClass = javaType.storageClass(),
            )
    }
}
