@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowEmpty Allows referer to be empty. Defaults false.
 * @property referers The list of referer.
 */
public data class BucketRefererConfig(
    public val allowEmpty: Boolean? = null,
    public val referers: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketRefererConfig): BucketRefererConfig = BucketRefererConfig(
            allowEmpty = javaType.allowEmpty().map({ args0 -> args0 }).orElse(null),
            referers = javaType.referers().map({ args0 -> args0 }),
        )
    }
}
