@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The destination bucket to which the data is replicated.
 * @property location The region in which the destination bucket is located.
 * @property transferType The link used to transfer data in data replication.. Can be `internal` or `oss_acc`. Defaults to `internal`.
 * `NOTE`: You can set transfer_type to oss_acc only when you create cross-region replication (CRR) rules.
 */
public data class BucketReplicationDestination(
    public val bucket: String,
    public val location: String,
    public val transferType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketReplicationDestination): BucketReplicationDestination = BucketReplicationDestination(
            bucket = javaType.bucket(),
            location = javaType.location(),
            transferType = javaType.transferType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
