@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property historicalObject The percentage of the replicated historical data. This element is valid only when historical_object_replication is set to enabled.
 * @property newObject The time used to distinguish new data from historical data. Data that is written to the source bucket before the time is replicated to the destination bucket as new data. The value of this element is in GMT.
 */
public data class BucketReplicationProgress(
    public val historicalObject: String? = null,
    public val newObject: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketReplicationProgress): BucketReplicationProgress = BucketReplicationProgress(
            historicalObject = javaType.historicalObject().map({ args0 -> args0 }).orElse(null),
            newObject = javaType.newObject().map({ args0 -> args0 }).orElse(null),
        )
    }
}
