@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsMasterKeyId The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
 * @property sseAlgorithm The server-side encryption algorithm to use. Possible values: `AES256` and `KMS`.
 */
public data class BucketServerSideEncryptionRule(
    public val kmsMasterKeyId: String? = null,
    public val sseAlgorithm: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketServerSideEncryptionRule): BucketServerSideEncryptionRule = BucketServerSideEncryptionRule(
            kmsMasterKeyId = javaType.kmsMasterKeyId().map({ args0 -> args0 }).orElse(null),
            sseAlgorithm = javaType.sseAlgorithm(),
        )
    }
}
