@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property errorDocument An absolute path to the document to return in case of a 4XX error.
 * @property indexDocument Alicloud OSS returns this index document when requests are made to the root domain or any of the subfolders.
 */
public data class BucketWebsite(
    public val errorDocument: String? = null,
    public val indexDocument: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.BucketWebsite): BucketWebsite =
            BucketWebsite(
                errorDocument = javaType.errorDocument().map({ args0 -> args0 }).orElse(null),
                indexDocument = javaType.indexDocument(),
            )
    }
}
