@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acl Object access control list. Possible values: `default`, `private`, `public-read` and `public-read-write`.
 * @property cacheControl Caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
 * @property contentDisposition Presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
 * @property contentEncoding Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
 * @property contentLength Size of the object in bytes.
 * @property contentMd5 MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
 * @property contentType Standard MIME type describing the format of the object data, e.g. "application/octet-stream".
 * @property etag ETag generated for the object (MD5 sum of the object content).
 * @property expires Expiration date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
 * @property key Object key.
 * @property lastModificationTime Last modification time of the object.
 * @property serverSideEncryption Server-side encryption of the object in OSS. It can be empty or `AES256`.
 * @property sseKmsKeyId If present, specifies the ID of the Key Management Service(KMS) master encryption key that was used for the object.
 * @property storageClass Object storage type. Possible values: `Standard`, `IA`, `Archive` and `ColdArchive`.
 */
public data class GetBucketObjectsObject(
    public val acl: String,
    public val cacheControl: String,
    public val contentDisposition: String,
    public val contentEncoding: String,
    public val contentLength: String,
    public val contentMd5: String,
    public val contentType: String,
    public val etag: String,
    public val expires: String,
    public val key: String,
    public val lastModificationTime: String,
    public val serverSideEncryption: String,
    public val sseKmsKeyId: String,
    public val storageClass: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.GetBucketObjectsObject): GetBucketObjectsObject = GetBucketObjectsObject(
            acl = javaType.acl(),
            cacheControl = javaType.cacheControl(),
            contentDisposition = javaType.contentDisposition(),
            contentEncoding = javaType.contentEncoding(),
            contentLength = javaType.contentLength(),
            contentMd5 = javaType.contentMd5(),
            contentType = javaType.contentType(),
            etag = javaType.etag(),
            expires = javaType.expires(),
            key = javaType.key(),
            lastModificationTime = javaType.lastModificationTime(),
            serverSideEncryption = javaType.serverSideEncryption(),
            sseKmsKeyId = javaType.sseKmsKeyId(),
            storageClass = javaType.storageClass(),
        )
    }
}
