@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBucketObjects.
 * @property bucketName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyPrefix
 * @property keyRegex
 * @property objects A list of bucket objects. Each element contains the following attributes:
 * @property outputFile
 */
public data class GetBucketObjectsResult(
    public val bucketName: String,
    public val id: String,
    public val keyPrefix: String? = null,
    public val keyRegex: String? = null,
    public val objects: List<GetBucketObjectsObject>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.GetBucketObjectsResult): GetBucketObjectsResult = GetBucketObjectsResult(
            bucketName = javaType.bucketName(),
            id = javaType.id(),
            keyPrefix = javaType.keyPrefix().map({ args0 -> args0 }).orElse(null),
            keyRegex = javaType.keyRegex().map({ args0 -> args0 }).orElse(null),
            objects = javaType.objects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.GetBucketObjectsObject.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
