@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property acl Bucket access control list. Possible values: `private`, `public-read` and `public-read-write`.
 * @property corsRules A list of CORS rule configurations. Each element contains the following attributes:
 * @property creationDate Bucket creation date.
 * @property extranetEndpoint Internet domain name for accessing the bucket from outside.
 * @property intranetEndpoint Intranet domain name for accessing the bucket from an ECS instance in the same region.
 * @property lifecycleRules A list CORS of lifecycle configurations. When Lifecycle is enabled, OSS automatically deletes the objects or transitions the objects (to another storage class) corresponding the lifecycle rules on a regular basis. Each element contains the following attributes:
 * @property location Region of the data center where the bucket is located.
 * @property logging A list of one element containing configuration parameters used for storing access log information. It contains the following attributes:
 * @property name Bucket name.
 * @property owner Bucket owner.
 * @property policy
 * @property redundancyType Redundancy type. Possible values: `LRS`, and `ZRS`.
 * @property refererConfig A list of one element containing referer configuration. It contains the following attributes:
 * @property serverSideEncryptionRule A configuration of default encryption for a bucket. It contains the following attributes:
 * @property storageClass Object storage type. Possible values: `Standard`, `IA`, `Archive` and `ColdArchive`.
 * @property tags A mapping of tags.
 * @property versioning If present , the versioning state has been set on the bucket. It contains the following attribute.
 * @property website A list of one element containing configuration parameters used when the bucket is used as a website. It contains the following attributes:
 */
public data class GetBucketsBucket(
    public val acl: String,
    public val corsRules: List<GetBucketsBucketCorsRule>,
    public val creationDate: String,
    public val extranetEndpoint: String,
    public val intranetEndpoint: String,
    public val lifecycleRules: List<GetBucketsBucketLifecycleRule>,
    public val location: String,
    public val logging: GetBucketsBucketLogging,
    public val name: String,
    public val owner: String,
    public val policy: String? = null,
    public val redundancyType: String,
    public val refererConfig: GetBucketsBucketRefererConfig,
    public val serverSideEncryptionRule: GetBucketsBucketServerSideEncryptionRule,
    public val storageClass: String,
    public val tags: Map<String, String>,
    public val versioning: GetBucketsBucketVersioning,
    public val website: GetBucketsBucketWebsite,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.GetBucketsBucket): GetBucketsBucket = GetBucketsBucket(
            acl = javaType.acl(),
            corsRules = javaType.corsRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsBucketCorsRule.Companion.toKotlin(args0)
                })
            }),
            creationDate = javaType.creationDate(),
            extranetEndpoint = javaType.extranetEndpoint(),
            intranetEndpoint = javaType.intranetEndpoint(),
            lifecycleRules = javaType.lifecycleRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsBucketLifecycleRule.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            logging = javaType.logging().let({ args0 ->
                com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsBucketLogging.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            owner = javaType.owner(),
            policy = javaType.policy().map({ args0 -> args0 }).orElse(null),
            redundancyType = javaType.redundancyType(),
            refererConfig = javaType.refererConfig().let({ args0 ->
                com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsBucketRefererConfig.Companion.toKotlin(args0)
            }),
            serverSideEncryptionRule = javaType.serverSideEncryptionRule().let({ args0 ->
                com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsBucketServerSideEncryptionRule.Companion.toKotlin(args0)
            }),
            storageClass = javaType.storageClass(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            versioning = javaType.versioning().let({ args0 ->
                com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsBucketVersioning.Companion.toKotlin(args0)
            }),
            website = javaType.website().let({ args0 ->
                com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsBucketWebsite.Companion.toKotlin(args0)
            }),
        )
    }
}
