@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowedHeaders Control whether the headers specified by Access-Control-Request-Headers in the OPTIONS prefetch command are allowed. Each header specified by Access-Control-Request-Headers must match a value in AllowedHeader. Each rule allows up to one wildcard “*” .
 * @property allowedMethods Specify the allowed methods for cross-domain requests. Possible values: `GET`, `PUT`, `DELETE`, `POST` and `HEAD`.
 * @property allowedOrigins The origins allowed for cross-domain requests. Multiple elements can be used to specify multiple allowed origins. Each rule allows up to one wildcard "\*". If "\*" is specified, cross-domain requests of all origins are allowed.
 * @property exposeHeaders Specify the response headers allowing users to access from an application (for example, a Javascript XMLHttpRequest object). The wildcard "\*" is not allowed.
 * @property maxAgeSeconds Specify the cache time for the returned result of a browser prefetch (OPTIONS) request to a specific resource.
 */
public data class GetBucketsBucketCorsRule(
    public val allowedHeaders: List<String>,
    public val allowedMethods: List<String>,
    public val allowedOrigins: List<String>,
    public val exposeHeaders: List<String>,
    public val maxAgeSeconds: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.GetBucketsBucketCorsRule): GetBucketsBucketCorsRule = GetBucketsBucketCorsRule(
            allowedHeaders = javaType.allowedHeaders().map({ args0 -> args0 }),
            allowedMethods = javaType.allowedMethods().map({ args0 -> args0 }),
            allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
            exposeHeaders = javaType.exposeHeaders().map({ args0 -> args0 }),
            maxAgeSeconds = javaType.maxAgeSeconds(),
        )
    }
}
