@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Indicate whether the rule is enabled or not.
 * @property expiration A list of one element containing expiration attributes of an object. It contains the following attributes:
 * @property id Unique ID of the rule.
 * @property prefix Prefix applicable to a rule. Only those objects with a matching prefix can be affected by the rule.
 */
public data class GetBucketsBucketLifecycleRule(
    public val enabled: Boolean,
    public val expiration: GetBucketsBucketLifecycleRuleExpiration,
    public val id: String,
    public val prefix: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.GetBucketsBucketLifecycleRule): GetBucketsBucketLifecycleRule = GetBucketsBucketLifecycleRule(
            enabled = javaType.enabled(),
            expiration = javaType.expiration().let({ args0 ->
                com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsBucketLifecycleRuleExpiration.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            prefix = javaType.prefix(),
        )
    }
}
