@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowEmpty Indicate whether the access request referer field can be empty.
 * @property referers Referer access whitelist.
 */
public data class GetBucketsBucketRefererConfig(
    public val allowEmpty: Boolean,
    public val referers: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.GetBucketsBucketRefererConfig): GetBucketsBucketRefererConfig = GetBucketsBucketRefererConfig(
            allowEmpty = javaType.allowEmpty(),
            referers = javaType.referers().map({ args0 -> args0 }),
        )
    }
}
