@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsMasterKeyId The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
 * @property sseAlgorithm The server-side encryption algorithm to use.
 */
public data class GetBucketsBucketServerSideEncryptionRule(
    public val kmsMasterKeyId: String,
    public val sseAlgorithm: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.GetBucketsBucketServerSideEncryptionRule): GetBucketsBucketServerSideEncryptionRule = GetBucketsBucketServerSideEncryptionRule(
            kmsMasterKeyId = javaType.kmsMasterKeyId(),
            sseAlgorithm = javaType.sseAlgorithm(),
        )
    }
}
