@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBuckets.
 * @property buckets A list of buckets. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property nameRegex
 * @property names A list of bucket names.
 * @property outputFile
 */
public data class GetBucketsResult(
    public val buckets: List<GetBucketsBucket>,
    public val id: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.GetBucketsResult): GetBucketsResult = GetBucketsResult(
            buckets = javaType.buckets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsBucket.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
