@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTables.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of table IDs.
 * @property instanceName The OTS instance name.
 * @property nameRegex
 * @property names A list of table names.
 * @property outputFile
 * @property tables A list of tables. Each element contains the following attributes:
 */
public data class GetTablesResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceName: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val tables: List<GetTablesTable>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oss.outputs.GetTablesResult): GetTablesResult = GetTablesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceName = javaType.instanceName(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            tables = javaType.tables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oss.kotlin.outputs.GetTablesTable.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
