@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.ots.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * This resource will help you to manager a [Table Store](https://www.alibabacloud.com/help/doc-detail/27280.htm) Instance.
 * It is foundation of creating data table.
 * > **NOTE:** Available since v1.10.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultInstance = new alicloud.ots.Instance("default", {
 *     name: `${name}-${_default.result}`,
 *     description: name,
 *     accessedBy: "Vpc",
 *     tags: {
 *         Created: "TF",
 *         For: "Building table",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_instance = alicloud.ots.Instance("default",
 *     name=f"{name}-{default['result']}",
 *     description=name,
 *     accessed_by="Vpc",
 *     tags={
 *         "Created": "TF",
 *         "For": "Building table",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultInstance = new AliCloud.Ots.Instance("default", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *         Description = name,
 *         AccessedBy = "Vpc",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "Building table" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ots.NewInstance(ctx, "default", &ots.InstanceArgs{
 * 			Name:        pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Description: pulumi.String(name),
 * 			AccessedBy:  pulumi.String("Vpc"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("Building table"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ots.Instance;
 * import com.pulumi.alicloud.ots.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .name(String.format("%s-%s", name,default_.result()))
 *             .description(name)
 *             .accessedBy("Vpc")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "Building table")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultInstance:
 *     type: alicloud:ots:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${default.result}
 *       description: ${name}
 *       accessedBy: Vpc
 *       tags:
 *         Created: TF
 *         For: Building table
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OTS instance can be imported using instance id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:ots/instance:Instance foo "my-ots-instance"
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.ots.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The network limitation of accessing instance. Valid values:
     * * `Any` - Allow all network to access the instance.
     * * `Vpc` - Only can the attached VPC allow to access the instance.
     * * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.
     * Default to "Any".
     */
    public val accessedBy: Output<String>
        get() = javaResource.accessedBy().applyValue({ args0 -> args0 })

    /**
     * The description of the instance. Currently, it does not support modifying.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
     */
    public val instanceType: Output<String>?
        get() = javaResource.instanceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the instance.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The set of request sources that are allowed access. Valid optional values:
     * * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.
     * Default to ["TRUST_PROXY"].
     */
    public val networkSourceAcls: Output<List<String>>
        get() = javaResource.networkSourceAcls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The set of network types that are allowed access. Valid optional values:
     * * `CLASSIC` - Classic network.
     * * `VPC` - VPC network.
     * * `INTERNET` - Public internet.
     * Default to ["VPC", "CLASSIC", "INTERNET"].
     */
    public val networkTypeAcls: Output<List<String>>
        get() = javaResource.networkTypeAcls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The resource group the instance belongs to.
     * Default to Alibaba Cloud default resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the instance.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ots.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.ots.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
