@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin

import com.pulumi.alicloud.ots.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This resource will help you to manager a [Table Store](https://www.alibabacloud.com/help/doc-detail/27280.htm) Instance.
 * It is foundation of creating data table.
 * > **NOTE:** Available since v1.10.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultInstance = new alicloud.ots.Instance("default", {
 *     name: `${name}-${_default.result}`,
 *     description: name,
 *     accessedBy: "Vpc",
 *     tags: {
 *         Created: "TF",
 *         For: "Building table",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_instance = alicloud.ots.Instance("default",
 *     name=f"{name}-{default['result']}",
 *     description=name,
 *     accessed_by="Vpc",
 *     tags={
 *         "Created": "TF",
 *         "For": "Building table",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultInstance = new AliCloud.Ots.Instance("default", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *         Description = name,
 *         AccessedBy = "Vpc",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "Building table" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ots.NewInstance(ctx, "default", &ots.InstanceArgs{
 * 			Name:        pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Description: pulumi.String(name),
 * 			AccessedBy:  pulumi.String("Vpc"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("Building table"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ots.Instance;
 * import com.pulumi.alicloud.ots.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .name(String.format("%s-%s", name,default_.result()))
 *             .description(name)
 *             .accessedBy("Vpc")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "Building table")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultInstance:
 *     type: alicloud:ots:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${default.result}
 *       description: ${name}
 *       accessedBy: Vpc
 *       tags:
 *         Created: TF
 *         For: Building table
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OTS instance can be imported using instance id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:ots/instance:Instance foo "my-ots-instance"
 * ```
 * @property accessedBy The network limitation of accessing instance. Valid values:
 * * `Any` - Allow all network to access the instance.
 * * `Vpc` - Only can the attached VPC allow to access the instance.
 * * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.
 * Default to "Any".
 * @property description The description of the instance. Currently, it does not support modifying.
 * @property instanceType The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
 * @property name The name of the instance.
 * @property networkSourceAcls The set of request sources that are allowed access. Valid optional values:
 * * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.
 * Default to ["TRUST_PROXY"].
 * @property networkTypeAcls The set of network types that are allowed access. Valid optional values:
 * * `CLASSIC` - Classic network.
 * * `VPC` - VPC network.
 * * `INTERNET` - Public internet.
 * Default to ["VPC", "CLASSIC", "INTERNET"].
 * @property resourceGroupId The resource group the instance belongs to.
 * Default to Alibaba Cloud default resource group.
 * @property tags A mapping of tags to assign to the instance.
 */
public data class InstanceArgs(
    public val accessedBy: Output<String>? = null,
    public val description: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkSourceAcls: Output<List<String>>? = null,
    public val networkTypeAcls: Output<List<String>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ots.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.InstanceArgs =
        com.pulumi.alicloud.ots.InstanceArgs.builder()
            .accessedBy(accessedBy?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkSourceAcls(networkSourceAcls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .networkTypeAcls(networkTypeAcls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var accessedBy: Output<String>? = null

    private var description: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var name: Output<String>? = null

    private var networkSourceAcls: Output<List<String>>? = null

    private var networkTypeAcls: Output<List<String>>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The network limitation of accessing instance. Valid values:
     * * `Any` - Allow all network to access the instance.
     * * `Vpc` - Only can the attached VPC allow to access the instance.
     * * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.
     * Default to "Any".
     */
    @JvmName("tnwduxvcwjekvxwy")
    public suspend fun accessedBy(`value`: Output<String>) {
        this.accessedBy = value
    }

    /**
     * @param value The description of the instance. Currently, it does not support modifying.
     */
    @JvmName("lwitwmtnudyrxlry")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
     */
    @JvmName("csklmvxjhvejsvrq")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The name of the instance.
     */
    @JvmName("dalhjrsqgtilswly")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The set of request sources that are allowed access. Valid optional values:
     * * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.
     * Default to ["TRUST_PROXY"].
     */
    @JvmName("afcoemaxccscpvxo")
    public suspend fun networkSourceAcls(`value`: Output<List<String>>) {
        this.networkSourceAcls = value
    }

    @JvmName("pkvtlfgkgapmvqov")
    public suspend fun networkSourceAcls(vararg values: Output<String>) {
        this.networkSourceAcls = Output.all(values.asList())
    }

    /**
     * @param values The set of request sources that are allowed access. Valid optional values:
     * * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.
     * Default to ["TRUST_PROXY"].
     */
    @JvmName("tjkyinnmouunagpf")
    public suspend fun networkSourceAcls(values: List<Output<String>>) {
        this.networkSourceAcls = Output.all(values)
    }

    /**
     * @param value The set of network types that are allowed access. Valid optional values:
     * * `CLASSIC` - Classic network.
     * * `VPC` - VPC network.
     * * `INTERNET` - Public internet.
     * Default to ["VPC", "CLASSIC", "INTERNET"].
     */
    @JvmName("qffdvcwmpnckxiwv")
    public suspend fun networkTypeAcls(`value`: Output<List<String>>) {
        this.networkTypeAcls = value
    }

    @JvmName("ixtkkvkytripbwwe")
    public suspend fun networkTypeAcls(vararg values: Output<String>) {
        this.networkTypeAcls = Output.all(values.asList())
    }

    /**
     * @param values The set of network types that are allowed access. Valid optional values:
     * * `CLASSIC` - Classic network.
     * * `VPC` - VPC network.
     * * `INTERNET` - Public internet.
     * Default to ["VPC", "CLASSIC", "INTERNET"].
     */
    @JvmName("mywioieecosvwawo")
    public suspend fun networkTypeAcls(values: List<Output<String>>) {
        this.networkTypeAcls = Output.all(values)
    }

    /**
     * @param value The resource group the instance belongs to.
     * Default to Alibaba Cloud default resource group.
     */
    @JvmName("uqhugulfpfgomqnb")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the instance.
     */
    @JvmName("igjtutimipjbidwo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The network limitation of accessing instance. Valid values:
     * * `Any` - Allow all network to access the instance.
     * * `Vpc` - Only can the attached VPC allow to access the instance.
     * * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.
     * Default to "Any".
     */
    @JvmName("sygwqugpmtrhuege")
    public suspend fun accessedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessedBy = mapped
    }

    /**
     * @param value The description of the instance. Currently, it does not support modifying.
     */
    @JvmName("jvfraxldbjnghnst")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
     */
    @JvmName("gthbbbbjrcwvyjsm")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The name of the instance.
     */
    @JvmName("wnwlmafbsffbdflv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The set of request sources that are allowed access. Valid optional values:
     * * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.
     * Default to ["TRUST_PROXY"].
     */
    @JvmName("ettqduuprkjmsujn")
    public suspend fun networkSourceAcls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSourceAcls = mapped
    }

    /**
     * @param values The set of request sources that are allowed access. Valid optional values:
     * * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.
     * Default to ["TRUST_PROXY"].
     */
    @JvmName("qpanagrmbjogohis")
    public suspend fun networkSourceAcls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkSourceAcls = mapped
    }

    /**
     * @param value The set of network types that are allowed access. Valid optional values:
     * * `CLASSIC` - Classic network.
     * * `VPC` - VPC network.
     * * `INTERNET` - Public internet.
     * Default to ["VPC", "CLASSIC", "INTERNET"].
     */
    @JvmName("xnqdpjqajtuhfdrf")
    public suspend fun networkTypeAcls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkTypeAcls = mapped
    }

    /**
     * @param values The set of network types that are allowed access. Valid optional values:
     * * `CLASSIC` - Classic network.
     * * `VPC` - VPC network.
     * * `INTERNET` - Public internet.
     * Default to ["VPC", "CLASSIC", "INTERNET"].
     */
    @JvmName("cimrqbvhlngxtjti")
    public suspend fun networkTypeAcls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkTypeAcls = mapped
    }

    /**
     * @param value The resource group the instance belongs to.
     * Default to Alibaba Cloud default resource group.
     */
    @JvmName("eptirlcfljygxcyj")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the instance.
     */
    @JvmName("dadcdceakrfkyrdq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the instance.
     */
    @JvmName("iqtfvhnoqwwvwhbw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        accessedBy = accessedBy,
        description = description,
        instanceType = instanceType,
        name = name,
        networkSourceAcls = networkSourceAcls,
        networkTypeAcls = networkTypeAcls,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
