@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin

import com.pulumi.alicloud.ots.OtsFunctions.getInstanceAttachmentsPlain
import com.pulumi.alicloud.ots.OtsFunctions.getInstancesPlain
import com.pulumi.alicloud.ots.OtsFunctions.getSearchIndexesPlain
import com.pulumi.alicloud.ots.OtsFunctions.getSecondaryIndexesPlain
import com.pulumi.alicloud.ots.OtsFunctions.getServicePlain
import com.pulumi.alicloud.ots.OtsFunctions.getTablesPlain
import com.pulumi.alicloud.ots.OtsFunctions.getTunnelsPlain
import com.pulumi.alicloud.ots.kotlin.inputs.GetInstanceAttachmentsPlainArgs
import com.pulumi.alicloud.ots.kotlin.inputs.GetInstanceAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.ots.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.ots.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.ots.kotlin.inputs.GetSearchIndexesPlainArgs
import com.pulumi.alicloud.ots.kotlin.inputs.GetSearchIndexesPlainArgsBuilder
import com.pulumi.alicloud.ots.kotlin.inputs.GetSecondaryIndexesPlainArgs
import com.pulumi.alicloud.ots.kotlin.inputs.GetSecondaryIndexesPlainArgsBuilder
import com.pulumi.alicloud.ots.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.ots.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.ots.kotlin.inputs.GetTablesPlainArgs
import com.pulumi.alicloud.ots.kotlin.inputs.GetTablesPlainArgsBuilder
import com.pulumi.alicloud.ots.kotlin.inputs.GetTunnelsPlainArgs
import com.pulumi.alicloud.ots.kotlin.inputs.GetTunnelsPlainArgsBuilder
import com.pulumi.alicloud.ots.kotlin.outputs.GetInstanceAttachmentsResult
import com.pulumi.alicloud.ots.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.ots.kotlin.outputs.GetSearchIndexesResult
import com.pulumi.alicloud.ots.kotlin.outputs.GetSecondaryIndexesResult
import com.pulumi.alicloud.ots.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.ots.kotlin.outputs.GetTablesResult
import com.pulumi.alicloud.ots.kotlin.outputs.GetTunnelsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.ots.kotlin.outputs.GetInstanceAttachmentsResult.Companion.toKotlin as getInstanceAttachmentsResultToKotlin
import com.pulumi.alicloud.ots.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.ots.kotlin.outputs.GetSearchIndexesResult.Companion.toKotlin as getSearchIndexesResultToKotlin
import com.pulumi.alicloud.ots.kotlin.outputs.GetSecondaryIndexesResult.Companion.toKotlin as getSecondaryIndexesResultToKotlin
import com.pulumi.alicloud.ots.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.ots.kotlin.outputs.GetTablesResult.Companion.toKotlin as getTablesResultToKotlin
import com.pulumi.alicloud.ots.kotlin.outputs.GetTunnelsResult.Companion.toKotlin as getTunnelsResultToKotlin

public object OtsFunctions {
    /**
     * This data source provides the ots instance attachments of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const attachmentsDs = alicloud.ots.getInstanceAttachments({
     *     instanceName: "sample-instance",
     *     nameRegex: "testvpc",
     *     outputFile: "attachments.txt",
     * });
     * export const firstOtsAttachmentId = attachmentsDs.then(attachmentsDs => attachmentsDs.attachments?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * attachments_ds = alicloud.ots.get_instance_attachments(instance_name="sample-instance",
     *     name_regex="testvpc",
     *     output_file="attachments.txt")
     * pulumi.export("firstOtsAttachmentId", attachments_ds.attachments[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var attachmentsDs = AliCloud.Ots.GetInstanceAttachments.Invoke(new()
     *     {
     *         InstanceName = "sample-instance",
     *         NameRegex = "testvpc",
     *         OutputFile = "attachments.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstOtsAttachmentId"] = attachmentsDs&#46;Apply(getInstanceAttachmentsResult => getInstanceAttachmentsResult&#46;Attachments[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		attachmentsDs, err := ots.GetInstanceAttachments(ctx, &ots.GetInstanceAttachmentsArgs{
     * 			InstanceName: "sample-instance",
     * 			NameRegex:    pulumi.StringRef("testvpc"),
     * 			OutputFile:   pulumi.StringRef("attachments.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstOtsAttachmentId", attachmentsDs.Attachments[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ots.OtsFunctions;
     * import com.pulumi.alicloud.ots.inputs.GetInstanceAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var attachmentsDs = OtsFunctions.getInstanceAttachments(GetInstanceAttachmentsArgs.builder()
     *             .instanceName("sample-instance")
     *             .nameRegex("testvpc")
     *             .outputFile("attachments.txt")
     *             .build());
     *         ctx.export("firstOtsAttachmentId", attachmentsDs.applyValue(getInstanceAttachmentsResult -> getInstanceAttachmentsResult.attachments()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   attachmentsDs:
     *     fn::invoke:
     *       Function: alicloud:ots:getInstanceAttachments
     *       Arguments:
     *         instanceName: sample-instance
     *         nameRegex: testvpc
     *         outputFile: attachments.txt
     * outputs:
     *   firstOtsAttachmentId: ${attachmentsDs.attachments[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceAttachments.
     * @return A collection of values returned by getInstanceAttachments.
     */
    public suspend fun getInstanceAttachments(argument: GetInstanceAttachmentsPlainArgs): GetInstanceAttachmentsResult =
        getInstanceAttachmentsResultToKotlin(getInstanceAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getInstanceAttachments].
     * @param instanceName The name of OTS instance.
     * @param nameRegex A regex string to filter results by vpc name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getInstanceAttachments.
     */
    public suspend fun getInstanceAttachments(
        instanceName: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetInstanceAttachmentsResult {
        val argument = GetInstanceAttachmentsPlainArgs(
            instanceName = instanceName,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getInstanceAttachmentsResultToKotlin(getInstanceAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ots&#46;kotlin&#46;inputs&#46;GetInstanceAttachmentsPlainArgs].
     * @return A collection of values returned by getInstanceAttachments.
     */
    public suspend fun getInstanceAttachments(argument: suspend GetInstanceAttachmentsPlainArgsBuilder.() -> Unit): GetInstanceAttachmentsResult {
        val builder = GetInstanceAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceAttachmentsResultToKotlin(getInstanceAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ots instances of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.40.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const instancesDs = alicloud.ots.getInstances({
     *     outputFile: "instances.txt",
     * });
     * export const firstInstanceId = instancesDs.then(instancesDs => instancesDs.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instances_ds = alicloud.ots.get_instances(output_file="instances.txt")
     * pulumi.export("firstInstanceId", instances_ds.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instancesDs = AliCloud.Ots.GetInstances.Invoke(new()
     *     {
     *         OutputFile = "instances.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstInstanceId"] = instancesDs&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		instancesDs, err := ots.GetInstances(ctx, &ots.GetInstancesArgs{
     * 			OutputFile: pulumi.StringRef("instances.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstInstanceId", instancesDs.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ots.OtsFunctions;
     * import com.pulumi.alicloud.ots.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instancesDs = OtsFunctions.getInstances(GetInstancesArgs.builder()
     *             .outputFile("instances.txt")
     *             .build());
     *         ctx.export("firstInstanceId", instancesDs.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instancesDs:
     *     fn::invoke:
     *       Function: alicloud:ots:getInstances
     *       Arguments:
     *         outputFile: instances.txt
     * outputs:
     *   firstInstanceId: ${instancesDs.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param ids A list of instance IDs.
     * @param nameRegex A regex string to filter results by instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tags A map of tags assigned to the instance. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const instancesDs = alicloud.ots.getInstances({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instances_ds = alicloud.ots.get_instances(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instancesDs = AliCloud.Ots.GetInstances.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ots.GetInstances(ctx, &ots.GetInstancesArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ots.OtsFunctions;
     * import com.pulumi.alicloud.ots.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instancesDs = OtsFunctions.getInstances(GetInstancesArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instancesDs:
     *     fn::invoke:
     *       Function: alicloud:ots:getInstances
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ots&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ots search index of the current Alibaba Cloud user.
     * For information about OTS search index and how to use it, see [Search index overview](https://www.alibabacloud.com/help/en/tablestore/latest/search-index-overview).
     * > **NOTE:** Available in v1.187.0+.
     * @param argument A collection of arguments for invoking getSearchIndexes.
     * @return A collection of values returned by getSearchIndexes.
     */
    public suspend fun getSearchIndexes(argument: GetSearchIndexesPlainArgs): GetSearchIndexesResult =
        getSearchIndexesResultToKotlin(getSearchIndexesPlain(argument.toJava()).await())

    /**
     * @see [getSearchIndexes].
     * @param ids A list of search index IDs.
     * @param instanceName The name of OTS instance.
     * @param nameRegex A regex string to filter results by search index name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tableName The name of OTS table.
     * @return A collection of values returned by getSearchIndexes.
     */
    public suspend fun getSearchIndexes(
        ids: List<String>? = null,
        instanceName: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        tableName: String,
    ): GetSearchIndexesResult {
        val argument = GetSearchIndexesPlainArgs(
            ids = ids,
            instanceName = instanceName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tableName = tableName,
        )
        return getSearchIndexesResultToKotlin(getSearchIndexesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSearchIndexes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ots&#46;kotlin&#46;inputs&#46;GetSearchIndexesPlainArgs].
     * @return A collection of values returned by getSearchIndexes.
     */
    public suspend fun getSearchIndexes(argument: suspend GetSearchIndexesPlainArgsBuilder.() -> Unit): GetSearchIndexesResult {
        val builder = GetSearchIndexesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSearchIndexesResultToKotlin(getSearchIndexesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ots secondary index of the current Alibaba Cloud user.
     * For information about OTS secondary index and how to use it, see [Secondary index overview](https://www.alibabacloud.com/help/en/tablestore/latest/secondary-index-overview).
     * > **NOTE:** Available in v1.187.0+.
     * ## Example Usage
     * ``` terraform
     * data "alicloud_ots_secondary_indexes" "secondary_index_ds" {
     *   instance_name = "sample-instance"
     *   table_name = "sample-table"
     *   name_regex    = "sample-secondary-index"
     *   output_file   = "secondary-indexs.txt"
     * }
     * output "first_secondary_index_id" {
     *   value = "${data.alicloud_ots_secondary_indexes.secondary_index_ds.indexs.0.id}"
     * }
     * ```
     * @param argument A collection of arguments for invoking getSecondaryIndexes.
     * @return A collection of values returned by getSecondaryIndexes.
     */
    public suspend fun getSecondaryIndexes(argument: GetSecondaryIndexesPlainArgs): GetSecondaryIndexesResult =
        getSecondaryIndexesResultToKotlin(getSecondaryIndexesPlain(argument.toJava()).await())

    /**
     * @see [getSecondaryIndexes].
     * @param ids A list of secondary index IDs.
     * @param instanceName The name of OTS instance.
     * @param nameRegex A regex string to filter results by secondary index name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tableName The name of OTS table.
     * @return A collection of values returned by getSecondaryIndexes.
     */
    public suspend fun getSecondaryIndexes(
        ids: List<String>? = null,
        instanceName: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        tableName: String,
    ): GetSecondaryIndexesResult {
        val argument = GetSecondaryIndexesPlainArgs(
            ids = ids,
            instanceName = instanceName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tableName = tableName,
        )
        return getSecondaryIndexesResultToKotlin(getSecondaryIndexesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecondaryIndexes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ots&#46;kotlin&#46;inputs&#46;GetSecondaryIndexesPlainArgs].
     * @return A collection of values returned by getSecondaryIndexes.
     */
    public suspend fun getSecondaryIndexes(argument: suspend GetSecondaryIndexesPlainArgsBuilder.() -> Unit): GetSecondaryIndexesResult {
        val builder = GetSecondaryIndexesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecondaryIndexesResultToKotlin(getSecondaryIndexesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can enable Table Staore service automatically. If the service has been enabled, it will return `Opened`.
     * For information about Table Staore and how to use it, see [What is Table Staore](https://www.alibabacloud.com/help/product/27278.htm).
     * > **NOTE:** Available in v1.97.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.ots.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.ots.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Ots.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ots.GetService(ctx, &ots.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ots.OtsFunctions;
     * import com.pulumi.alicloud.ots.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = OtsFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:ots:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the Table Staore service that means you have read and agreed the [Table Staore Terms of Service](https://help.aliyun.com/document_detail/34908.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ots&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ots tables of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.40.0+.
     * ## Example Usage
     * ``` terraform
     * data "alicloud_ots_tables" "tables_ds" {
     *   instance_name = "sample-instance"
     *   name_regex    = "sample-table"
     *   output_file   = "tables.txt"
     * }
     * output "first_table_id" {
     *   value = "${data.alicloud_ots_tables.tables_ds.tables.0.id}"
     * }
     * ```
     * @param argument A collection of arguments for invoking getTables.
     * @return A collection of values returned by getTables.
     */
    public suspend fun getTables(argument: GetTablesPlainArgs): GetTablesResult =
        getTablesResultToKotlin(getTablesPlain(argument.toJava()).await())

    /**
     * @see [getTables].
     * @param ids A list of table IDs.
     * @param instanceName The name of OTS instance.
     * @param nameRegex A regex string to filter results by table name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getTables.
     */
    public suspend fun getTables(
        ids: List<String>? = null,
        instanceName: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetTablesResult {
        val argument = GetTablesPlainArgs(
            ids = ids,
            instanceName = instanceName,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getTablesResultToKotlin(getTablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTables].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ots&#46;kotlin&#46;inputs&#46;GetTablesPlainArgs].
     * @return A collection of values returned by getTables.
     */
    public suspend fun getTables(argument: suspend GetTablesPlainArgsBuilder.() -> Unit): GetTablesResult {
        val builder = GetTablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTablesResultToKotlin(getTablesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ots tunnels of the current Alibaba Cloud user.
     * For information about OTS tunnel and how to use it, see [Tunnel overview](https://www.alibabacloud.com/help/en/tablestore/latest/tunnel-service-overview).
     * > **NOTE:** Available in v1.172.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const tunnelsDs = alicloud.ots.getTunnels({
     *     instanceName: "sample-instance",
     *     tableName: "sample-table",
     *     nameRegex: "sample-tunnel",
     *     outputFile: "tunnels.txt",
     * });
     * export const firstTunnelId = tunnelsDs.then(tunnelsDs => tunnelsDs.tunnels?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * tunnels_ds = alicloud.ots.get_tunnels(instance_name="sample-instance",
     *     table_name="sample-table",
     *     name_regex="sample-tunnel",
     *     output_file="tunnels.txt")
     * pulumi.export("firstTunnelId", tunnels_ds.tunnels[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var tunnelsDs = AliCloud.Ots.GetTunnels.Invoke(new()
     *     {
     *         InstanceName = "sample-instance",
     *         TableName = "sample-table",
     *         NameRegex = "sample-tunnel",
     *         OutputFile = "tunnels.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTunnelId"] = tunnelsDs&#46;Apply(getTunnelsResult => getTunnelsResult&#46;Tunnels[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		tunnelsDs, err := ots.GetTunnels(ctx, &ots.GetTunnelsArgs{
     * 			InstanceName: "sample-instance",
     * 			TableName:    "sample-table",
     * 			NameRegex:    pulumi.StringRef("sample-tunnel"),
     * 			OutputFile:   pulumi.StringRef("tunnels.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstTunnelId", tunnelsDs.Tunnels[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ots.OtsFunctions;
     * import com.pulumi.alicloud.ots.inputs.GetTunnelsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var tunnelsDs = OtsFunctions.getTunnels(GetTunnelsArgs.builder()
     *             .instanceName("sample-instance")
     *             .tableName("sample-table")
     *             .nameRegex("sample-tunnel")
     *             .outputFile("tunnels.txt")
     *             .build());
     *         ctx.export("firstTunnelId", tunnelsDs.applyValue(getTunnelsResult -> getTunnelsResult.tunnels()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   tunnelsDs:
     *     fn::invoke:
     *       Function: alicloud:ots:getTunnels
     *       Arguments:
     *         instanceName: sample-instance
     *         tableName: sample-table
     *         nameRegex: sample-tunnel
     *         outputFile: tunnels.txt
     * outputs:
     *   firstTunnelId: ${tunnelsDs.tunnels[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTunnels.
     * @return A collection of values returned by getTunnels.
     */
    public suspend fun getTunnels(argument: GetTunnelsPlainArgs): GetTunnelsResult =
        getTunnelsResultToKotlin(getTunnelsPlain(argument.toJava()).await())

    /**
     * @see [getTunnels].
     * @param ids A list of tunnel IDs.
     * @param instanceName The name of OTS instance.
     * @param nameRegex A regex string to filter results by tunnel name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tableName The name of OTS table.
     * @return A collection of values returned by getTunnels.
     */
    public suspend fun getTunnels(
        ids: List<String>? = null,
        instanceName: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        tableName: String,
    ): GetTunnelsResult {
        val argument = GetTunnelsPlainArgs(
            ids = ids,
            instanceName = instanceName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tableName = tableName,
        )
        return getTunnelsResultToKotlin(getTunnelsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTunnels].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ots&#46;kotlin&#46;inputs&#46;GetTunnelsPlainArgs].
     * @return A collection of values returned by getTunnels.
     */
    public suspend fun getTunnels(argument: suspend GetTunnelsPlainArgsBuilder.() -> Unit): GetTunnelsResult {
        val builder = GetTunnelsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTunnelsResultToKotlin(getTunnelsPlain(builtArgument.toJava()).await())
    }
}
