@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin

import com.pulumi.alicloud.ots.kotlin.outputs.SearchIndexSchema
import com.pulumi.alicloud.ots.kotlin.outputs.SearchIndexSchema.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SearchIndex].
 */
@PulumiTagMarker
public class SearchIndexResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SearchIndexArgs = SearchIndexArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SearchIndexArgsBuilder.() -> Unit) {
        val builder = SearchIndexArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SearchIndex {
        val builtJavaResource = com.pulumi.alicloud.ots.SearchIndex(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SearchIndex(builtJavaResource)
    }
}

/**
 * Provides an OTS search index resource.
 * For information about OTS search index and how to use it, see [Search index overview](https://www.alibabacloud.com/help/en/tablestore/latest/search-index-overview).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultInstance = new alicloud.ots.Instance("default", {
 *     name: `${name}-${_default.result}`,
 *     description: name,
 *     accessedBy: "Any",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultTable = new alicloud.ots.Table("default", {
 *     instanceName: defaultInstance.name,
 *     tableName: "tf_example",
 *     timeToLive: -1,
 *     maxVersion: 1,
 *     enableSse: true,
 *     sseKeyType: "SSE_KMS_SERVICE",
 *     primaryKeys: [
 *         {
 *             name: "pk1",
 *             type: "Integer",
 *         },
 *         {
 *             name: "pk2",
 *             type: "String",
 *         },
 *         {
 *             name: "pk3",
 *             type: "Binary",
 *         },
 *     ],
 * });
 * const defaultSearchIndex = new alicloud.ots.SearchIndex("default", {
 *     instanceName: defaultInstance.name,
 *     tableName: defaultTable.tableName,
 *     indexName: "example_index",
 *     timeToLive: -1,
 *     schemas: [{
 *         fieldSchemas: [
 *             {
 *                 fieldName: "col1",
 *                 fieldType: "Text",
 *                 isArray: false,
 *                 index: true,
 *                 analyzer: "Split",
 *                 store: true,
 *             },
 *             {
 *                 fieldName: "col2",
 *                 fieldType: "Long",
 *                 enableSortAndAgg: true,
 *             },
 *             {
 *                 fieldName: "pk1",
 *                 fieldType: "Long",
 *             },
 *             {
 *                 fieldName: "pk2",
 *                 fieldType: "Text",
 *             },
 *         ],
 *         indexSettings: [{
 *             routingFields: [
 *                 "pk1",
 *                 "pk2",
 *             ],
 *         }],
 *         indexSorts: [{
 *             sorters: [
 *                 {
 *                     sorterType: "PrimaryKeySort",
 *                     order: "Asc",
 *                 },
 *                 {
 *                     sorterType: "FieldSort",
 *                     order: "Desc",
 *                     fieldName: "col2",
 *                     mode: "Max",
 *                 },
 *             ],
 *         }],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_instance = alicloud.ots.Instance("default",
 *     name=f"{name}-{default['result']}",
 *     description=name,
 *     accessed_by="Any",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_table = alicloud.ots.Table("default",
 *     instance_name=default_instance.name,
 *     table_name="tf_example",
 *     time_to_live=-1,
 *     max_version=1,
 *     enable_sse=True,
 *     sse_key_type="SSE_KMS_SERVICE",
 *     primary_keys=[
 *         {
 *             "name": "pk1",
 *             "type": "Integer",
 *         },
 *         {
 *             "name": "pk2",
 *             "type": "String",
 *         },
 *         {
 *             "name": "pk3",
 *             "type": "Binary",
 *         },
 *     ])
 * default_search_index = alicloud.ots.SearchIndex("default",
 *     instance_name=default_instance.name,
 *     table_name=default_table.table_name,
 *     index_name="example_index",
 *     time_to_live=-1,
 *     schemas=[{
 *         "field_schemas": [
 *             {
 *                 "field_name": "col1",
 *                 "field_type": "Text",
 *                 "is_array": False,
 *                 "index": True,
 *                 "analyzer": "Split",
 *                 "store": True,
 *             },
 *             {
 *                 "field_name": "col2",
 *                 "field_type": "Long",
 *                 "enable_sort_and_agg": True,
 *             },
 *             {
 *                 "field_name": "pk1",
 *                 "field_type": "Long",
 *             },
 *             {
 *                 "field_name": "pk2",
 *                 "field_type": "Text",
 *             },
 *         ],
 *         "index_settings": [{
 *             "routing_fields": [
 *                 "pk1",
 *                 "pk2",
 *             ],
 *         }],
 *         "index_sorts": [{
 *             "sorters": [
 *                 {
 *                     "sorter_type": "PrimaryKeySort",
 *                     "order": "Asc",
 *                 },
 *                 {
 *                     "sorter_type": "FieldSort",
 *                     "order": "Desc",
 *                     "field_name": "col2",
 *                     "mode": "Max",
 *                 },
 *             ],
 *         }],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultInstance = new AliCloud.Ots.Instance("default", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *         Description = name,
 *         AccessedBy = "Any",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultTable = new AliCloud.Ots.Table("default", new()
 *     {
 *         InstanceName = defaultInstance.Name,
 *         TableName = "tf_example",
 *         TimeToLive = -1,
 *         MaxVersion = 1,
 *         EnableSse = true,
 *         SseKeyType = "SSE_KMS_SERVICE",
 *         PrimaryKeys = new[]
 *         {
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk1",
 *                 Type = "Integer",
 *             },
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk2",
 *                 Type = "String",
 *             },
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk3",
 *                 Type = "Binary",
 *             },
 *         },
 *     });
 *     var defaultSearchIndex = new AliCloud.Ots.SearchIndex("default", new()
 *     {
 *         InstanceName = defaultInstance.Name,
 *         TableName = defaultTable.TableName,
 *         IndexName = "example_index",
 *         TimeToLive = -1,
 *         Schemas = new[]
 *         {
 *             new AliCloud.Ots.Inputs.SearchIndexSchemaArgs
 *             {
 *                 FieldSchemas = new[]
 *                 {
 *                     new AliCloud.Ots.Inputs.SearchIndexSchemaFieldSchemaArgs
 *                     {
 *                         FieldName = "col1",
 *                         FieldType = "Text",
 *                         IsArray = false,
 *                         Index = true,
 *                         Analyzer = "Split",
 *                         Store = true,
 *                     },
 *                     new AliCloud.Ots.Inputs.SearchIndexSchemaFieldSchemaArgs
 *                     {
 *                         FieldName = "col2",
 *                         FieldType = "Long",
 *                         EnableSortAndAgg = true,
 *                     },
 *                     new AliCloud.Ots.Inputs.SearchIndexSchemaFieldSchemaArgs
 *                     {
 *                         FieldName = "pk1",
 *                         FieldType = "Long",
 *                     },
 *                     new AliCloud.Ots.Inputs.SearchIndexSchemaFieldSchemaArgs
 *                     {
 *                         FieldName = "pk2",
 *                         FieldType = "Text",
 *                     },
 *                 },
 *                 IndexSettings = new[]
 *                 {
 *                     new AliCloud.Ots.Inputs.SearchIndexSchemaIndexSettingArgs
 *                     {
 *                         RoutingFields = new[]
 *                         {
 *                             "pk1",
 *                             "pk2",
 *                         },
 *                     },
 *                 },
 *                 IndexSorts = new[]
 *                 {
 *                     new AliCloud.Ots.Inputs.SearchIndexSchemaIndexSortArgs
 *                     {
 *                         Sorters = new[]
 *                         {
 *                             new AliCloud.Ots.Inputs.SearchIndexSchemaIndexSortSorterArgs
 *                             {
 *                                 SorterType = "PrimaryKeySort",
 *                                 Order = "Asc",
 *                             },
 *                             new AliCloud.Ots.Inputs.SearchIndexSchemaIndexSortSorterArgs
 *                             {
 *                                 SorterType = "FieldSort",
 *                                 Order = "Desc",
 *                                 FieldName = "col2",
 *                                 Mode = "Max",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ots.NewInstance(ctx, "default", &ots.InstanceArgs{
 * 			Name:        pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Description: pulumi.String(name),
 * 			AccessedBy:  pulumi.String("Any"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTable, err := ots.NewTable(ctx, "default", &ots.TableArgs{
 * 			InstanceName: defaultInstance.Name,
 * 			TableName:    pulumi.String("tf_example"),
 * 			TimeToLive:   int(-1),
 * 			MaxVersion:   pulumi.Int(1),
 * 			EnableSse:    pulumi.Bool(true),
 * 			SseKeyType:   pulumi.String("SSE_KMS_SERVICE"),
 * 			PrimaryKeys: ots.TablePrimaryKeyArray{
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk1"),
 * 					Type: pulumi.String("Integer"),
 * 				},
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk2"),
 * 					Type: pulumi.String("String"),
 * 				},
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk3"),
 * 					Type: pulumi.String("Binary"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ots.NewSearchIndex(ctx, "default", &ots.SearchIndexArgs{
 * 			InstanceName: defaultInstance.Name,
 * 			TableName:    defaultTable.TableName,
 * 			IndexName:    pulumi.String("example_index"),
 * 			TimeToLive:   int(-1),
 * 			Schemas: ots.SearchIndexSchemaArray{
 * 				&ots.SearchIndexSchemaArgs{
 * 					FieldSchemas: ots.SearchIndexSchemaFieldSchemaArray{
 * 						&ots.SearchIndexSchemaFieldSchemaArgs{
 * 							FieldName: pulumi.String("col1"),
 * 							FieldType: pulumi.String("Text"),
 * 							IsArray:   pulumi.Bool(false),
 * 							Index:     pulumi.Bool(true),
 * 							Analyzer:  pulumi.String("Split"),
 * 							Store:     pulumi.Bool(true),
 * 						},
 * 						&ots.SearchIndexSchemaFieldSchemaArgs{
 * 							FieldName:        pulumi.String("col2"),
 * 							FieldType:        pulumi.String("Long"),
 * 							EnableSortAndAgg: pulumi.Bool(true),
 * 						},
 * 						&ots.SearchIndexSchemaFieldSchemaArgs{
 * 							FieldName: pulumi.String("pk1"),
 * 							FieldType: pulumi.String("Long"),
 * 						},
 * 						&ots.SearchIndexSchemaFieldSchemaArgs{
 * 							FieldName: pulumi.String("pk2"),
 * 							FieldType: pulumi.String("Text"),
 * 						},
 * 					},
 * 					IndexSettings: ots.SearchIndexSchemaIndexSettingArray{
 * 						&ots.SearchIndexSchemaIndexSettingArgs{
 * 							RoutingFields: pulumi.StringArray{
 * 								pulumi.String("pk1"),
 * 								pulumi.String("pk2"),
 * 							},
 * 						},
 * 					},
 * 					IndexSorts: ots.SearchIndexSchemaIndexSortArray{
 * 						&ots.SearchIndexSchemaIndexSortArgs{
 * 							Sorters: ots.SearchIndexSchemaIndexSortSorterArray{
 * 								&ots.SearchIndexSchemaIndexSortSorterArgs{
 * 									SorterType: pulumi.String("PrimaryKeySort"),
 * 									Order:      pulumi.String("Asc"),
 * 								},
 * 								&ots.SearchIndexSchemaIndexSortSorterArgs{
 * 									SorterType: pulumi.String("FieldSort"),
 * 									Order:      pulumi.String("Desc"),
 * 									FieldName:  pulumi.String("col2"),
 * 									Mode:       pulumi.String("Max"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultInstance:
 *     type: alicloud:ots:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${default.result}
 *       description: ${name}
 *       accessedBy: Any
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultTable:
 *     type: alicloud:ots:Table
 *     name: default
 *     properties:
 *       instanceName: ${defaultInstance.name}
 *       tableName: tf_example
 *       timeToLive: -1
 *       maxVersion: 1
 *       enableSse: true
 *       sseKeyType: SSE_KMS_SERVICE
 *       primaryKeys:
 *         - name: pk1
 *           type: Integer
 *         - name: pk2
 *           type: String
 *         - name: pk3
 *           type: Binary
 *   defaultSearchIndex:
 *     type: alicloud:ots:SearchIndex
 *     name: default
 *     properties:
 *       instanceName: ${defaultInstance.name}
 *       tableName: ${defaultTable.tableName}
 *       indexName: example_index
 *       timeToLive: -1
 *       schemas:
 *         - fieldSchemas:
 *             - fieldName: col1
 *               fieldType: Text
 *               isArray: false
 *               index: true
 *               analyzer: Split
 *               store: true
 *             - fieldName: col2
 *               fieldType: Long
 *               enableSortAndAgg: true
 *             - fieldName: pk1
 *               fieldType: Long
 *             - fieldName: pk2
 *               fieldType: Text
 *           indexSettings:
 *             - routingFields:
 *                 - pk1
 *                 - pk2
 *           indexSorts:
 *             - sorters:
 *                 - sorterType: PrimaryKeySort
 *                   order: Asc
 *                 - sorterType: FieldSort
 *                   order: Desc
 *                   fieldName: col2
 *                   mode: Max
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OTS search index can be imported using id, e.g.
 * ```sh
 * $ pulumi import alicloud:ots/searchIndex:SearchIndex index1 <instance_name>:<table_name>:<index_name>:<index_type>
 * ```
 */
public class SearchIndex internal constructor(
    override val javaResource: com.pulumi.alicloud.ots.SearchIndex,
) : KotlinCustomResource(javaResource, SearchIndexMapper) {
    /**
     * The search index create time.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The timestamp for sync phase.
     */
    public val currentSyncTimestamp: Output<Int>
        get() = javaResource.currentSyncTimestamp().applyValue({ args0 -> args0 })

    /**
     * The index id of the search index which could not be changed.
     */
    public val indexId: Output<String>
        get() = javaResource.indexId().applyValue({ args0 -> args0 })

    /**
     * The index name of the OTS Table. If changed, a new index would be created.
     */
    public val indexName: Output<String>
        get() = javaResource.indexName().applyValue({ args0 -> args0 })

    /**
     * The name of the OTS instance in which table will located.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The schema of the search index. If changed, a new index would be created. See `schema` below.
     */
    public val schemas: Output<List<SearchIndexSchema>>
        get() = javaResource.schemas().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The search index sync phase. possible values: `Full`, `Incr`.
     */
    public val syncPhase: Output<String>
        get() = javaResource.syncPhase().applyValue({ args0 -> args0 })

    /**
     * The name of the OTS table. If changed, a new table would be created.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })

    /**
     * The index type of the OTS Table. Specifies the retention period of data in the search index. Unit: seconds. Default value: -1.
     * If the retention period exceeds the TTL value, OTS automatically deletes expired data.
     */
    public val timeToLive: Output<Int>?
        get() = javaResource.timeToLive().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SearchIndexMapper : ResourceMapper<SearchIndex> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ots.SearchIndex::class == javaResource::class

    override fun map(javaResource: Resource): SearchIndex = SearchIndex(
        javaResource as
            com.pulumi.alicloud.ots.SearchIndex,
    )
}

/**
 * @see [SearchIndex].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SearchIndex].
 */
public suspend fun searchIndex(name: String, block: suspend SearchIndexResourceBuilder.() -> Unit): SearchIndex {
    val builder = SearchIndexResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SearchIndex].
 * @param name The _unique_ name of the resulting resource.
 */
public fun searchIndex(name: String): SearchIndex {
    val builder = SearchIndexResourceBuilder()
    builder.name(name)
    return builder.build()
}
