@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SecondaryIndex].
 */
@PulumiTagMarker
public class SecondaryIndexResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecondaryIndexArgs = SecondaryIndexArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecondaryIndexArgsBuilder.() -> Unit) {
        val builder = SecondaryIndexArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecondaryIndex {
        val builtJavaResource = com.pulumi.alicloud.ots.SecondaryIndex(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecondaryIndex(builtJavaResource)
    }
}

/**
 * Provides an OTS secondary index resource.
 * For information about OTS secondary index and how to use it, see [Secondary index overview](https://www.alibabacloud.com/help/en/tablestore/latest/secondary-index-overview).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultInstance = new alicloud.ots.Instance("default", {
 *     name: `${name}-${_default.result}`,
 *     description: name,
 *     accessedBy: "Any",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultTable = new alicloud.ots.Table("default", {
 *     instanceName: defaultInstance.name,
 *     tableName: "tf_example",
 *     timeToLive: -1,
 *     maxVersion: 1,
 *     enableSse: true,
 *     sseKeyType: "SSE_KMS_SERVICE",
 *     primaryKeys: [
 *         {
 *             name: "pk1",
 *             type: "Integer",
 *         },
 *         {
 *             name: "pk2",
 *             type: "String",
 *         },
 *         {
 *             name: "pk3",
 *             type: "Binary",
 *         },
 *     ],
 *     definedColumns: [
 *         {
 *             name: "col1",
 *             type: "Integer",
 *         },
 *         {
 *             name: "col2",
 *             type: "String",
 *         },
 *         {
 *             name: "col3",
 *             type: "Binary",
 *         },
 *     ],
 * });
 * const defaultSecondaryIndex = new alicloud.ots.SecondaryIndex("default", {
 *     instanceName: defaultInstance.name,
 *     tableName: defaultTable.tableName,
 *     indexName: "example_index",
 *     indexType: "Global",
 *     includeBaseData: true,
 *     primaryKeys: [
 *         "pk1",
 *         "pk2",
 *         "pk3",
 *     ],
 *     definedColumns: [
 *         "col1",
 *         "col2",
 *         "col3",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_instance = alicloud.ots.Instance("default",
 *     name=f"{name}-{default['result']}",
 *     description=name,
 *     accessed_by="Any",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_table = alicloud.ots.Table("default",
 *     instance_name=default_instance.name,
 *     table_name="tf_example",
 *     time_to_live=-1,
 *     max_version=1,
 *     enable_sse=True,
 *     sse_key_type="SSE_KMS_SERVICE",
 *     primary_keys=[
 *         {
 *             "name": "pk1",
 *             "type": "Integer",
 *         },
 *         {
 *             "name": "pk2",
 *             "type": "String",
 *         },
 *         {
 *             "name": "pk3",
 *             "type": "Binary",
 *         },
 *     ],
 *     defined_columns=[
 *         {
 *             "name": "col1",
 *             "type": "Integer",
 *         },
 *         {
 *             "name": "col2",
 *             "type": "String",
 *         },
 *         {
 *             "name": "col3",
 *             "type": "Binary",
 *         },
 *     ])
 * default_secondary_index = alicloud.ots.SecondaryIndex("default",
 *     instance_name=default_instance.name,
 *     table_name=default_table.table_name,
 *     index_name="example_index",
 *     index_type="Global",
 *     include_base_data=True,
 *     primary_keys=[
 *         "pk1",
 *         "pk2",
 *         "pk3",
 *     ],
 *     defined_columns=[
 *         "col1",
 *         "col2",
 *         "col3",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultInstance = new AliCloud.Ots.Instance("default", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *         Description = name,
 *         AccessedBy = "Any",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultTable = new AliCloud.Ots.Table("default", new()
 *     {
 *         InstanceName = defaultInstance.Name,
 *         TableName = "tf_example",
 *         TimeToLive = -1,
 *         MaxVersion = 1,
 *         EnableSse = true,
 *         SseKeyType = "SSE_KMS_SERVICE",
 *         PrimaryKeys = new[]
 *         {
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk1",
 *                 Type = "Integer",
 *             },
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk2",
 *                 Type = "String",
 *             },
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk3",
 *                 Type = "Binary",
 *             },
 *         },
 *         DefinedColumns = new[]
 *         {
 *             new AliCloud.Ots.Inputs.TableDefinedColumnArgs
 *             {
 *                 Name = "col1",
 *                 Type = "Integer",
 *             },
 *             new AliCloud.Ots.Inputs.TableDefinedColumnArgs
 *             {
 *                 Name = "col2",
 *                 Type = "String",
 *             },
 *             new AliCloud.Ots.Inputs.TableDefinedColumnArgs
 *             {
 *                 Name = "col3",
 *                 Type = "Binary",
 *             },
 *         },
 *     });
 *     var defaultSecondaryIndex = new AliCloud.Ots.SecondaryIndex("default", new()
 *     {
 *         InstanceName = defaultInstance.Name,
 *         TableName = defaultTable.TableName,
 *         IndexName = "example_index",
 *         IndexType = "Global",
 *         IncludeBaseData = true,
 *         PrimaryKeys = new[]
 *         {
 *             "pk1",
 *             "pk2",
 *             "pk3",
 *         },
 *         DefinedColumns = new[]
 *         {
 *             "col1",
 *             "col2",
 *             "col3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ots.NewInstance(ctx, "default", &ots.InstanceArgs{
 * 			Name:        pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Description: pulumi.String(name),
 * 			AccessedBy:  pulumi.String("Any"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTable, err := ots.NewTable(ctx, "default", &ots.TableArgs{
 * 			InstanceName: defaultInstance.Name,
 * 			TableName:    pulumi.String("tf_example"),
 * 			TimeToLive:   int(-1),
 * 			MaxVersion:   pulumi.Int(1),
 * 			EnableSse:    pulumi.Bool(true),
 * 			SseKeyType:   pulumi.String("SSE_KMS_SERVICE"),
 * 			PrimaryKeys: ots.TablePrimaryKeyArray{
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk1"),
 * 					Type: pulumi.String("Integer"),
 * 				},
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk2"),
 * 					Type: pulumi.String("String"),
 * 				},
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk3"),
 * 					Type: pulumi.String("Binary"),
 * 				},
 * 			},
 * 			DefinedColumns: ots.TableDefinedColumnArray{
 * 				&ots.TableDefinedColumnArgs{
 * 					Name: pulumi.String("col1"),
 * 					Type: pulumi.String("Integer"),
 * 				},
 * 				&ots.TableDefinedColumnArgs{
 * 					Name: pulumi.String("col2"),
 * 					Type: pulumi.String("String"),
 * 				},
 * 				&ots.TableDefinedColumnArgs{
 * 					Name: pulumi.String("col3"),
 * 					Type: pulumi.String("Binary"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ots.NewSecondaryIndex(ctx, "default", &ots.SecondaryIndexArgs{
 * 			InstanceName:    defaultInstance.Name,
 * 			TableName:       defaultTable.TableName,
 * 			IndexName:       pulumi.String("example_index"),
 * 			IndexType:       pulumi.String("Global"),
 * 			IncludeBaseData: pulumi.Bool(true),
 * 			PrimaryKeys: pulumi.StringArray{
 * 				pulumi.String("pk1"),
 * 				pulumi.String("pk2"),
 * 				pulumi.String("pk3"),
 * 			},
 * 			DefinedColumns: pulumi.StringArray{
 * 				pulumi.String("col1"),
 * 				pulumi.String("col2"),
 * 				pulumi.String("col3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultInstance:
 *     type: alicloud:ots:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${default.result}
 *       description: ${name}
 *       accessedBy: Any
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultTable:
 *     type: alicloud:ots:Table
 *     name: default
 *     properties:
 *       instanceName: ${defaultInstance.name}
 *       tableName: tf_example
 *       timeToLive: -1
 *       maxVersion: 1
 *       enableSse: true
 *       sseKeyType: SSE_KMS_SERVICE
 *       primaryKeys:
 *         - name: pk1
 *           type: Integer
 *         - name: pk2
 *           type: String
 *         - name: pk3
 *           type: Binary
 *       definedColumns:
 *         - name: col1
 *           type: Integer
 *         - name: col2
 *           type: String
 *         - name: col3
 *           type: Binary
 *   defaultSecondaryIndex:
 *     type: alicloud:ots:SecondaryIndex
 *     name: default
 *     properties:
 *       instanceName: ${defaultInstance.name}
 *       tableName: ${defaultTable.tableName}
 *       indexName: example_index
 *       indexType: Global
 *       includeBaseData: true
 *       primaryKeys:
 *         - pk1
 *         - pk2
 *         - pk3
 *       definedColumns:
 *         - col1
 *         - col2
 *         - col3
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OTS secondary index can be imported using id, e.g.
 * ```sh
 * $ pulumi import alicloud:ots/secondaryIndex:SecondaryIndex index1 <instance_name>:<table_name>:<index_name>:<index_type>
 * ```
 */
public class SecondaryIndex internal constructor(
    override val javaResource: com.pulumi.alicloud.ots.SecondaryIndex,
) : KotlinCustomResource(javaResource, SecondaryIndexMapper) {
    /**
     * A list of defined column for index, referenced from Table's primary keys or predefined columns.
     */
    public val definedColumns: Output<List<String>>?
        get() = javaResource.definedColumns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * whether the index contains data that already exists in the data table. When include_base_data is set to true, it means that stock data is included.
     */
    public val includeBaseData: Output<Boolean>
        get() = javaResource.includeBaseData().applyValue({ args0 -> args0 })

    /**
     * The index name of the OTS Table. If changed, a new index would be created.
     */
    public val indexName: Output<String>
        get() = javaResource.indexName().applyValue({ args0 -> args0 })

    /**
     * The index type of the OTS Table. If changed, a new index would be created, only `Global` or `Local` is allowed.
     */
    public val indexType: Output<String>
        get() = javaResource.indexType().applyValue({ args0 -> args0 })

    /**
     * The name of the OTS instance in which table will located.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * A list of primary keys for index, referenced from Table's primary keys or predefined columns.
     */
    public val primaryKeys: Output<List<String>>
        get() = javaResource.primaryKeys().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the OTS table. If changed, a new table would be created.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })
}

public object SecondaryIndexMapper : ResourceMapper<SecondaryIndex> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ots.SecondaryIndex::class == javaResource::class

    override fun map(javaResource: Resource): SecondaryIndex = SecondaryIndex(
        javaResource as
            com.pulumi.alicloud.ots.SecondaryIndex,
    )
}

/**
 * @see [SecondaryIndex].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecondaryIndex].
 */
public suspend fun secondaryIndex(
    name: String,
    block: suspend SecondaryIndexResourceBuilder.() -> Unit,
): SecondaryIndex {
    val builder = SecondaryIndexResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecondaryIndex].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secondaryIndex(name: String): SecondaryIndex {
    val builder = SecondaryIndexResourceBuilder()
    builder.name(name)
    return builder.build()
}
